/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.graphql.orchestrate.transform;

import graphql.analysis.QueryTransformer;
import graphql.analysis.QueryVisitor;
import graphql.analysis.QueryVisitorFieldEnvironment;
import graphql.analysis.QueryVisitorStub;
import graphql.com.google.common.collect.Lists;
import graphql.language.Field;
import graphql.language.Node;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphQLTypeVisitorStub;
import graphql.schema.SchemaTransformer;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dotwebstack.graphql.orchestrate.Request;
import org.dotwebstack.graphql.orchestrate.transform.RequestMapping;
import org.dotwebstack.graphql.orchestrate.transform.SchemaMapping;
import org.dotwebstack.graphql.orchestrate.transform.TransformException;

public class TransformUtils {
    private TransformUtils() {
    }

    public static GraphQLSchema mapSchema(GraphQLSchema schema, final SchemaMapping mapping) {
        GraphQLTypeVisitorStub typeVisitor = new GraphQLTypeVisitorStub(){

            public TraversalControl visitGraphQLObjectType(GraphQLObjectType node, TraverserContext<GraphQLSchemaElement> traverserContext) {
                return (TraversalControl)mapping.getObjectType().apply(node, traverserContext);
            }

            public TraversalControl visitGraphQLInterfaceType(GraphQLInterfaceType node, TraverserContext<GraphQLSchemaElement> traverserContext) {
                return (TraversalControl)mapping.getInterfaceType().apply(node, traverserContext);
            }
        };
        return SchemaTransformer.transformSchema((GraphQLSchema)schema, (GraphQLTypeVisitor)typeVisitor);
    }

    public static Request mapRequest(Request request, GraphQLSchema schema, final RequestMapping mapping) {
        QueryTransformer queryTransformer = QueryTransformer.newQueryTransformer().schema(schema).root((Node)request.getSelectionSet()).rootParentType((GraphQLCompositeType)schema.getQueryType()).fragmentsByName(Map.of()).variables(Map.of()).build();
        QueryVisitorStub queryVisitor = new QueryVisitorStub(){

            public TraversalControl visitFieldWithControl(QueryVisitorFieldEnvironment environment) {
                return mapping.getField().apply(environment);
            }
        };
        SelectionSet newSelectionSet = (SelectionSet)queryTransformer.transform((QueryVisitor)queryVisitor);
        return request.transform(builder -> builder.selectionSet(newSelectionSet).build());
    }

    public static <T> List<T> listAppend(List<T> list, T element) {
        return Stream.concat(list.stream(), Stream.of(element)).collect(Collectors.toList());
    }

    public static <T> List<T> listMerge(List<T> list1, List<T> list2) {
        return Stream.concat(list1.stream(), list2.stream()).collect(Collectors.toList());
    }

    public static boolean isField(Selection<?> selection, String fieldName) {
        return selection instanceof Field && fieldName.equals(((Field)selection).getName());
    }

    public static boolean containsField(SelectionSet selectionSet, String fieldName) {
        return selectionSet.getSelectionsOfType(Field.class).stream().anyMatch(field -> fieldName.equals(field.getName()));
    }

    public static SelectionSet includeFieldPath(SelectionSet selectionSet, SelectionSet leafSelectionSet, List<String> fieldPath) {
        String fieldName = fieldPath.get(0);
        int fieldPathSize = fieldPath.size();
        List<Object> selections = !TransformUtils.containsField(selectionSet, fieldName) ? TransformUtils.listAppend(selectionSet.getSelections(), Field.newField((String)fieldName).selectionSet(fieldPathSize > 1 ? TransformUtils.includeFieldPath(new SelectionSet(List.of()), leafSelectionSet, fieldPath.subList(1, fieldPath.size())) : leafSelectionSet).build()) : selectionSet.getSelections().stream().map(selection -> {
            if (TransformUtils.isField(selection, fieldName)) {
                Field field = (Field)selection;
                if (fieldPathSize == 1) {
                    return field;
                }
                return field.transform(builder -> builder.selectionSet(TransformUtils.includeFieldPath(field.getSelectionSet(), leafSelectionSet, fieldPath.subList(1, fieldPathSize))));
            }
            return selection;
        }).collect(Collectors.toList());
        return selectionSet.transform(builder -> builder.selections((Collection)selections));
    }

    public static SelectionSet getFieldSelectionSet(SelectionSet selectionSet, String fieldName) {
        return selectionSet.getSelections().stream().filter(selection -> TransformUtils.isField(selection, fieldName)).findFirst().map(selections -> ((Field)selections).getSelectionSet()).orElse(null);
    }

    public static SelectionSet excludeField(SelectionSet selectionSet, String fieldName) {
        List selections = selectionSet.getSelections().stream().filter(selection -> !TransformUtils.isField(selection, fieldName)).collect(Collectors.toList());
        return selectionSet.transform(builder -> builder.selections((Collection)selections));
    }

    public static List<String> getResultPath(TraverserContext<Node> traverserContext) {
        return Lists.reverse((List)traverserContext.getParentNodes()).stream().filter(Field.class::isInstance).map(Field.class::cast).map(Field::getResultKey).collect(Collectors.toList());
    }

    public static Object getFieldValue(Object data, List<String> fieldPath) {
        int fieldPathSize = fieldPath.size();
        Object fieldValue = TransformUtils.getFieldValue(data, fieldPath.get(0));
        if (fieldValue == null || fieldPathSize == 1) {
            return fieldValue;
        }
        return TransformUtils.getFieldValue(fieldValue, fieldPath.subList(1, fieldPathSize));
    }

    public static Object getFieldValue(Object data, String fieldKey) {
        if (data == null) {
            return null;
        }
        if (data instanceof List) {
            return ((List)data).stream().map(item -> TransformUtils.getFieldValue(item, fieldKey)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        if (data instanceof Map) {
            return ((Map)data).get(fieldKey);
        }
        throw new TransformException("Unsupported field type.");
    }

    public static Map<String, Object> putMapValue(Map<String, Object> inputMap, String key, Object value) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(inputMap);
        dataMap.put(key, value);
        return Collections.unmodifiableMap(dataMap);
    }

    public static Object mapTransform(Object data, List<String> fieldPath, UnaryOperator<Map<String, Object>> mapper) {
        return TransformUtils.mapApply(data, dataMap -> TransformUtils.mapTransform(dataMap, fieldPath, mapper));
    }

    public static Map<String, Object> mapTransform(Map<String, Object> data, List<String> fieldPath, UnaryOperator<Map<String, Object>> mapper) {
        int fieldPathSize = fieldPath.size();
        String fieldKey = fieldPath.get(0);
        Object fieldValue = data.get(fieldKey);
        if (fieldValue == null) {
            return TransformUtils.putMapValue(data, fieldKey, null);
        }
        if (fieldPathSize > 1) {
            return TransformUtils.putMapValue(data, fieldKey, TransformUtils.mapTransform(fieldValue, fieldPath.subList(1, fieldPathSize), mapper));
        }
        return TransformUtils.putMapValue(data, fieldKey, TransformUtils.mapApply(fieldValue, mapper));
    }

    public static Object mapApply(Object data, UnaryOperator<Map<String, Object>> mapper) {
        if (data instanceof List) {
            return ((List)data).stream().map(mapper).collect(Collectors.toList());
        }
        if (data instanceof Map) {
            return mapper.apply((Map)data);
        }
        throw new TransformException("Unsupported field type.");
    }

    public static <T> T noopCombiner(T o1, T o2) {
        throw new TransformException("Combining should never happen, since streams must be processed sequentially.");
    }
}

