/*
 * Decompiled with CFR 0.152.
 */
package org.hypertrace.agent.core.config;

import io.opentelemetry.javaagent.slf4j.Logger;
import io.opentelemetry.javaagent.slf4j.LoggerFactory;
import java.util.Iterator;
import java.util.ServiceLoader;

public interface DataCaptureConfig {
    public String[] getAllowedContentTypes();

    public static class ConfigProvider {
        private static final Logger logger = LoggerFactory.getLogger(ConfigProvider.class);
        private static volatile DataCaptureConfig dataCaptureConfig;

        private static DataCaptureConfig load(ClassLoader cl) {
            ServiceLoader<DataCaptureConfig> configs = ServiceLoader.load(DataCaptureConfig.class, cl);
            Iterator<DataCaptureConfig> iterator = configs.iterator();
            if (!iterator.hasNext()) {
                logger.error("Failed to load data capture config");
                return null;
            }
            return iterator.next();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static DataCaptureConfig get(ClassLoader cl) {
            if (dataCaptureConfig != null) return dataCaptureConfig;
            Class<ConfigProvider> clazz = ConfigProvider.class;
            synchronized (ConfigProvider.class) {
                if (dataCaptureConfig != null) return dataCaptureConfig;
                dataCaptureConfig = ConfigProvider.load(cl);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return dataCaptureConfig;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static DataCaptureConfig get() {
            if (dataCaptureConfig != null) return dataCaptureConfig;
            Class<ConfigProvider> clazz = ConfigProvider.class;
            synchronized (ConfigProvider.class) {
                if (dataCaptureConfig != null) return dataCaptureConfig;
                dataCaptureConfig = ConfigProvider.load(Thread.currentThread().getContextClassLoader());
                // ** MonitorExit[var0] (shouldn't be in output)
                return dataCaptureConfig;
            }
        }
    }
}

