/*
 * Decompiled with CFR 0.152.
 */
package org.hypertrace.agent.core.config;

import io.opentelemetry.javaagent.slf4j.Logger;
import io.opentelemetry.javaagent.slf4j.LoggerFactory;
import java.util.Iterator;
import java.util.ServiceLoader;

public interface ReportingConfig {
    public boolean secure();

    public String token();

    public static final class ConfigProvider {
        private static final Logger logger = LoggerFactory.getLogger(ConfigProvider.class);
        private static volatile ReportingConfig reportingConfig;

        private static ReportingConfig load(ClassLoader cl) {
            ServiceLoader<ReportingConfig> configs = ServiceLoader.load(ReportingConfig.class, cl);
            Iterator<ReportingConfig> iterator = configs.iterator();
            if (!iterator.hasNext()) {
                logger.error("Failed to load reporting config");
                return null;
            }
            return iterator.next();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static ReportingConfig get(ClassLoader cl) {
            if (reportingConfig != null) return reportingConfig;
            Class<ConfigProvider> clazz = ConfigProvider.class;
            synchronized (ConfigProvider.class) {
                if (reportingConfig != null) return reportingConfig;
                reportingConfig = ConfigProvider.load(cl);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return reportingConfig;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static ReportingConfig get() {
            if (reportingConfig != null) return reportingConfig;
            Class<ConfigProvider> clazz = ConfigProvider.class;
            synchronized (ConfigProvider.class) {
                if (reportingConfig != null) return reportingConfig;
                reportingConfig = ConfigProvider.load(Thread.currentThread().getContextClassLoader());
                // ** MonitorExit[var0] (shouldn't be in output)
                return reportingConfig;
            }
        }
    }
}

