/*
 * Decompiled with CFR 0.152.
 */
package org.hypertrace.agent.instrument;

import io.opentelemetry.javaagent.OpenTelemetryAgent;
import java.lang.instrument.Instrumentation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class HypertraceAgent {
    private static HypertraceAgent instance;

    public static void premain(String agentArgs, Instrumentation inst) {
        HypertraceAgent.agentmain(agentArgs, inst);
    }

    public static void agentmain(String agentArgs, Instrumentation inst) {
        if (HypertraceAgent.isTraceableAgentLoaded()) {
            System.out.println("Traceable agent is already running. Will not attempt to attach");
            return;
        }
        Map<String, String> parsedArgs = HypertraceAgent.parseAgentArgs(agentArgs);
        for (Map.Entry<String, String> argEntry : parsedArgs.entrySet()) {
            System.setProperty(argEntry.getKey(), argEntry.getValue());
        }
        if (instance != null) {
            System.out.println("Agent is already running. Will not attempt to attach");
            return;
        }
        instance = new HypertraceAgent();
        OpenTelemetryAgent.premain(agentArgs, inst);
        System.out.printf("Hypertrace agent started, version: %s\n", HypertraceAgent.class.getPackage().getImplementationVersion());
    }

    private static Map<String, String> parseAgentArgs(String agentArgs) {
        if (agentArgs == null) {
            return Collections.emptyMap();
        }
        String[] agentArgsArr = agentArgs.split(",");
        HashMap<String, String> argsMap = new HashMap<String, String>(agentArgsArr.length);
        for (String arg : agentArgsArr) {
            String[] splitAgentArg = arg.split("=");
            if (splitAgentArg.length != 2) {
                throw new IllegalArgumentException(String.format("Agent args is not well formed: %s. Use the format \"arg1=val1,arg2=val2,arg3=val3\"", arg));
            }
            argsMap.put(splitAgentArg[0], splitAgentArg[1]);
        }
        return argsMap;
    }

    private static boolean isTraceableAgentLoaded() {
        try {
            Class.forName("ai.traceable.agent.bootstrap.AgentContext", true, null);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }
}

