/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.java;

import java.io.File;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.benf.cfr.reader.api.CfrDriver;
import org.benf.cfr.reader.api.OutputSinkFactory;
import org.ifinalframework.java.ClassDumpTransformer;
import org.ifinalframework.java.Instrumentations;
import org.ifinalframework.util.Asserts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public final class Decompiler {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(Decompiler.class);

    private Decompiler() {
    }

    public static String decompile(@NonNull Class<?> clazz) {
        return Decompiler.decompile(clazz, null);
    }

    public static String decompile(@NonNull Class<?> clazz, @Nullable String methodName) {
        Instrumentation instrumentation = Instrumentations.get();
        HashSet classes = new HashSet(Collections.singletonList(clazz));
        URL root = ClassLoader.getSystemClassLoader().getResource(".");
        Objects.requireNonNull(root);
        ClassDumpTransformer transformer = new ClassDumpTransformer(classes, new File(root.getPath()));
        Instrumentations.retransformClasses(instrumentation, transformer, classes);
        Map<Class<?>, File> dumpResult = transformer.getDumpResult();
        File file = dumpResult.get(clazz);
        String absolutePath = file.getAbsolutePath();
        String decompile = Decompiler.decompile(absolutePath, methodName);
        boolean delete = file.delete();
        logger.info("delete decompile file {} {}", (Object)file.getName(), (Object)delete);
        return decompile;
    }

    public static String decompile(String classFilePath, String methodName) {
        return Decompiler.decompile(classFilePath, methodName, false);
    }

    public static String decompile(String classFilePath, String methodName, boolean hideUnicode) {
        final StringBuilder result = new StringBuilder(8192);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("showversion", "false");
        options.put("hideutf", String.valueOf(hideUnicode));
        if (Asserts.nonBlank((String)methodName)) {
            options.put("methodname", methodName);
        }
        OutputSinkFactory mySink = new OutputSinkFactory(){

            @Override
            public List<OutputSinkFactory.SinkClass> getSupportedSinks(OutputSinkFactory.SinkType sinkType, Collection<OutputSinkFactory.SinkClass> collection) {
                return Arrays.asList(OutputSinkFactory.SinkClass.STRING, OutputSinkFactory.SinkClass.DECOMPILED, OutputSinkFactory.SinkClass.DECOMPILED_MULTIVER, OutputSinkFactory.SinkClass.EXCEPTION_MESSAGE);
            }

            @Override
            public <T> OutputSinkFactory.Sink<T> getSink(OutputSinkFactory.SinkType sinkType, OutputSinkFactory.SinkClass sinkClass) {
                return sinkable -> {
                    if (sinkType == OutputSinkFactory.SinkType.PROGRESS) {
                        return;
                    }
                    result.append(sinkable);
                };
            }
        };
        CfrDriver driver = new CfrDriver.Builder().withOptions(options).withOutputSink(mySink).build();
        ArrayList<String> toAnalyse = new ArrayList<String>();
        toAnalyse.add(classFilePath);
        driver.analyse(toAnalyse);
        return result.toString();
    }
}

