/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.java;

import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.Map;
import lombok.Generated;
import org.ifinalframework.java.Instrumentations;
import org.ifinalframework.java.compiler.Compiler;
import org.ifinalframework.java.compiler.DynamicClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public final class Redefiner {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(Redefiner.class);

    private Redefiner() {
    }

    public static void redefine(@NonNull Class<?> clazz, @NonNull String source) {
        Instrumentation instrumentation = Instrumentations.get();
        ClassLoader classLoader = clazz.getClassLoader();
        Compiler compiler = new Compiler(classLoader);
        String className = clazz.getCanonicalName();
        compiler.addSource(className, source);
        DynamicClassLoader compile = compiler.compile();
        Map<String, byte[]> byteCodes = compile.getByteCodes();
        ArrayList<ClassDefinition> definitions = new ArrayList<ClassDefinition>();
        for (Class loadedClass : instrumentation.getAllLoadedClasses()) {
            if (!byteCodes.containsKey(loadedClass.getName()) || !loadedClass.getClassLoader().equals(classLoader)) continue;
            logger.info("try to redefine class {}", (Object)loadedClass.getName());
            definitions.add(new ClassDefinition(loadedClass, byteCodes.get(loadedClass.getName())));
        }
        try {
            instrumentation.redefineClasses(definitions.toArray(new ClassDefinition[0]));
        }
        catch (Exception e) {
            logger.error("redefine error! " + e.getMessage(), (Throwable)e);
        }
    }
}

