/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.java.compiler;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

public class BytesJavaFileObject
extends SimpleJavaFileObject {
    private static final char PKG_SEPARATOR = '.';
    private static final char DIR_SEPARATOR = '/';
    private static final String CLASS_FILE_SUFFIX = ".class";
    private ByteArrayOutputStream byteArrayOutputStream;

    public BytesJavaFileObject(String className) {
        super(URI.create("byte:///" + className.replace('.', '/') + JavaFileObject.Kind.CLASS.extension), JavaFileObject.Kind.CLASS);
    }

    public BytesJavaFileObject(String className, ByteArrayOutputStream byteArrayOutputStream) {
        this(className);
        this.byteArrayOutputStream = byteArrayOutputStream;
    }

    @Override
    public OutputStream openOutputStream() {
        if (this.byteArrayOutputStream == null) {
            this.byteArrayOutputStream = new ByteArrayOutputStream();
        }
        return this.byteArrayOutputStream;
    }

    public byte[] getByteCode() {
        return this.byteArrayOutputStream.toByteArray();
    }

    public String getClassName() {
        String className = this.getName();
        className = className.replace('/', '.');
        className = className.substring(1, className.indexOf(CLASS_FILE_SUFFIX));
        return className;
    }
}

