/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.issues;

import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import org.java_websocket.WebSocket;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.handshake.ServerHandshake;
import org.java_websocket.server.WebSocketServer;
import org.java_websocket.util.SocketUtil;
import org.junit.Assert;
import org.junit.Test;

public class Issue621Test {
    CountDownLatch countDownLatch = new CountDownLatch(1);
    CountDownLatch countServerDownLatch = new CountDownLatch(1);
    boolean wasError = false;

    @Test
    public void testIssue() throws Exception {
        System.setErr(new TestPrintStream(System.err));
        int port = SocketUtil.getAvailablePort();
        WebSocketClient webSocket = new WebSocketClient(new URI("ws://localhost:" + port)){

            public void onOpen(ServerHandshake handshakedata) {
            }

            public void onMessage(String message) {
            }

            public void onClose(int code, String reason, boolean remote) {
                Issue621Test.this.countDownLatch.countDown();
            }

            public void onError(Exception ex) {
            }
        };
        WebSocketServer server = new WebSocketServer(new InetSocketAddress(port)){

            public void onOpen(WebSocket conn, ClientHandshake handshake) {
                conn.close();
            }

            public void onClose(WebSocket conn, int code, String reason, boolean remote) {
            }

            public void onMessage(WebSocket conn, String message) {
            }

            public void onError(WebSocket conn, Exception ex) {
            }

            public void onStart() {
                Issue621Test.this.countServerDownLatch.countDown();
            }
        };
        server.start();
        this.countServerDownLatch.await();
        webSocket.connectBlocking();
        this.countDownLatch.await();
        Assert.assertTrue((String)"There was an error using System.err", (!this.wasError ? 1 : 0) != 0);
        server.stop();
    }

    class TestPrintStream
    extends PrintStream {
        public TestPrintStream(OutputStream out) {
            super(out);
        }

        @Override
        public void println(Object o) {
            Issue621Test.this.wasError = true;
            super.println(o);
        }
    }
}

