/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.issues;

import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import org.java_websocket.WebSocket;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.framing.Framedata;
import org.java_websocket.framing.PingFrame;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.handshake.ServerHandshake;
import org.java_websocket.server.WebSocketServer;
import org.java_websocket.util.SocketUtil;
import org.junit.Assert;
import org.junit.Test;

public class Issue941Test {
    private CountDownLatch pingLatch = new CountDownLatch(1);
    private CountDownLatch pongLatch = new CountDownLatch(1);
    private byte[] pingBuffer;
    private byte[] receivedPingBuffer;
    private byte[] pongBuffer;

    @Test
    public void testIssue() throws Exception {
        int port = SocketUtil.getAvailablePort();
        WebSocketClient client = new WebSocketClient(new URI("ws://localhost:" + port)){

            public void onOpen(ServerHandshake handshakedata) {
            }

            public void onMessage(String message) {
            }

            public void onClose(int code, String reason, boolean remote) {
            }

            public void onError(Exception ex) {
            }

            public PingFrame onPreparePing(WebSocket conn) {
                PingFrame frame = new PingFrame();
                Issue941Test.access$002(Issue941Test.this, new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
                frame.setPayload(ByteBuffer.wrap(Issue941Test.this.pingBuffer));
                return frame;
            }

            public void onWebsocketPong(WebSocket conn, Framedata f) {
                Issue941Test.access$102(Issue941Test.this, f.getPayloadData().array());
                Issue941Test.this.pongLatch.countDown();
            }
        };
        WebSocketServer server = new WebSocketServer(new InetSocketAddress(port)){

            public void onOpen(WebSocket conn, ClientHandshake handshake) {
            }

            public void onClose(WebSocket conn, int code, String reason, boolean remote) {
            }

            public void onMessage(WebSocket conn, String message) {
            }

            public void onError(WebSocket conn, Exception ex) {
            }

            public void onStart() {
            }

            public void onWebsocketPing(WebSocket conn, Framedata f) {
                Issue941Test.access$302(Issue941Test.this, f.getPayloadData().array());
                super.onWebsocketPing(conn, f);
                Issue941Test.this.pingLatch.countDown();
            }
        };
        server.start();
        client.connectBlocking();
        client.setConnectionLostTimeout(1);
        this.pingLatch.await();
        Assert.assertArrayEquals((byte[])this.pingBuffer, (byte[])this.receivedPingBuffer);
        this.pongLatch.await();
        Assert.assertArrayEquals((byte[])this.pingBuffer, (byte[])this.pongBuffer);
    }

    static /* synthetic */ byte[] access$002(Issue941Test x0, byte[] x1) {
        x0.pingBuffer = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$102(Issue941Test x0, byte[] x1) {
        x0.pongBuffer = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$302(Issue941Test x0, byte[] x1) {
        x0.receivedPingBuffer = x1;
        return x1;
    }
}

