/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.issues;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.java_websocket.WebSocket;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.handshake.ServerHandshake;
import org.java_websocket.server.WebSocketServer;
import org.java_websocket.util.SocketUtil;
import org.java_websocket.util.ThreadCheck;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class Issue256Test {
    private static final int NUMBER_OF_TESTS = 10;
    private static WebSocketServer ws;
    private static int port;
    static CountDownLatch countServerDownLatch;
    @Rule
    public ThreadCheck zombies = new ThreadCheck();
    @Parameterized.Parameter
    public int count;

    @BeforeClass
    public static void startServer() throws Exception {
        port = SocketUtil.getAvailablePort();
        ws = new WebSocketServer(new InetSocketAddress(port), 16){

            public void onOpen(WebSocket conn, ClientHandshake handshake) {
            }

            public void onClose(WebSocket conn, int code, String reason, boolean remote) {
            }

            public void onMessage(WebSocket conn, String message) {
                conn.send(message);
            }

            public void onError(WebSocket conn, Exception ex) {
                ex.printStackTrace();
                Assume.assumeThat((Object)true, (Matcher)Is.is((Object)false));
                System.out.println("There should be no exception!");
            }

            public void onStart() {
                countServerDownLatch.countDown();
            }
        };
        ws.setConnectionLostTimeout(0);
        ws.start();
    }

    private void runTestScenarioReconnect(boolean closeBlocking) throws Exception {
        final CountDownLatch countDownLatch0 = new CountDownLatch(1);
        final CountDownLatch countDownLatch1 = new CountDownLatch(2);
        WebSocketClient clt = new WebSocketClient(new URI("ws://localhost:" + port)){

            public void onOpen(ServerHandshake handshakedata) {
                countDownLatch1.countDown();
            }

            public void onMessage(String message) {
            }

            public void onClose(int code, String reason, boolean remote) {
                countDownLatch0.countDown();
            }

            public void onError(Exception ex) {
                ex.printStackTrace();
                Assume.assumeThat((Object)true, (Matcher)Is.is((Object)false));
                System.out.println("There should be no exception!");
            }
        };
        clt.connectBlocking();
        if (closeBlocking) {
            clt.closeBlocking();
        } else {
            clt.getSocket().close();
        }
        countDownLatch0.await();
        clt.reconnectBlocking();
        clt.closeBlocking();
    }

    @AfterClass
    public static void successTests() throws InterruptedException, IOException {
        ws.stop();
    }

    @Parameterized.Parameters
    public static Collection<Integer[]> data() {
        ArrayList<Integer[]> ret = new ArrayList<Integer[]>(10);
        for (int i = 0; i < 10; ++i) {
            ret.add(new Integer[]{i});
        }
        return ret;
    }

    @Test(timeout=5000L)
    public void runReconnectSocketClose() throws Exception {
        this.runTestScenarioReconnect(false);
    }

    @Test(timeout=5000L)
    public void runReconnectCloseBlocking() throws Exception {
        this.runTestScenarioReconnect(true);
    }

    static {
        countServerDownLatch = new CountDownLatch(1);
    }
}

