/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.cloudstack.domain.Zone;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.location.suppliers.JustProvider;

public class ZoneToLocation
implements Function<Zone, Location> {
    private final JustProvider provider;

    @Inject
    public ZoneToLocation(JustProvider provider) {
        this.provider = (JustProvider)Preconditions.checkNotNull((Object)provider, (Object)"provider");
    }

    public Location apply(Zone zone) {
        return new LocationBuilder().scope(LocationScope.ZONE).metadata((Map)ImmutableMap.of()).description(zone.getName()).id(Long.toString(zone.getId())).parent((Location)Iterables.getOnlyElement((Iterable)this.provider.get())).build();
    }
}

