/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import java.util.Date;

public class Event
implements Comparable<Event> {
    private long id;
    private String account;
    private String description;
    private Date created;
    private String domain;
    private long domainId;
    private String level;
    private String parentId;
    private String state;
    private String type;
    private String username;

    public static Builder builder() {
        return new Builder();
    }

    public Event(long id, String account, String description, Date created, String domain, long domainId, String level, String parentId, String state, String type, String username) {
        this.id = id;
        this.account = account;
        this.description = description;
        this.created = created;
        this.domain = domain;
        this.domainId = domainId;
        this.level = level;
        this.parentId = parentId;
        this.state = state;
        this.type = type;
        this.username = username;
    }

    Event() {
    }

    public long getId() {
        return this.id;
    }

    public String getAccount() {
        return this.account;
    }

    public Date getCreated() {
        return this.created;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDomain() {
        return this.domain;
    }

    public long getDomainId() {
        return this.domainId;
    }

    public String getLevel() {
        return this.level;
    }

    public String getParentId() {
        return this.parentId;
    }

    public String getState() {
        return this.state;
    }

    public String getType() {
        return this.type;
    }

    public String getUsername() {
        return this.username;
    }

    @Override
    public int compareTo(Event arg0) {
        return new Long(this.id).compareTo(arg0.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event event = (Event)o;
        if (this.domainId != event.domainId) {
            return false;
        }
        if (this.id != event.id) {
            return false;
        }
        if (this.account != null ? !this.account.equals(event.account) : event.account != null) {
            return false;
        }
        if (this.created != null ? !this.created.equals(event.created) : event.created != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(event.description) : event.description != null) {
            return false;
        }
        if (this.domain != null ? !this.domain.equals(event.domain) : event.domain != null) {
            return false;
        }
        if (this.level != null ? !this.level.equals(event.level) : event.level != null) {
            return false;
        }
        if (this.parentId != null ? !this.parentId.equals(event.parentId) : event.parentId != null) {
            return false;
        }
        if (this.state != null ? !this.state.equals(event.state) : event.state != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(event.type) : event.type != null) {
            return false;
        }
        return !(this.username != null ? !this.username.equals(event.username) : event.username != null);
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.account != null ? this.account.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.created != null ? this.created.hashCode() : 0);
        result = 31 * result + (this.domain != null ? this.domain.hashCode() : 0);
        result = 31 * result + (int)(this.domainId ^ this.domainId >>> 32);
        result = 31 * result + (this.level != null ? this.level.hashCode() : 0);
        result = 31 * result + (this.parentId != null ? this.parentId.hashCode() : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Event{id=" + this.id + ", account='" + this.account + '\'' + ", description='" + this.description + '\'' + ", created=" + this.created + ", domain='" + this.domain + '\'' + ", domainId=" + this.domainId + ", level='" + this.level + '\'' + ", parentId='" + this.parentId + '\'' + ", state='" + this.state + '\'' + ", type='" + this.type + '\'' + ", username='" + this.username + '\'' + '}';
    }

    public static class Builder {
        private long id;
        private String account;
        private String description;
        private Date created;
        private String domain;
        private long domainId;
        private String level;
        private String parentId;
        private String state;
        private String type;
        private String username;

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder account(String account) {
            this.account = account;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder domainId(long domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder level(String level) {
            this.level = level;
            return this;
        }

        public Builder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Event build() {
            return new Event(this.id, this.account, this.description, this.created, this.domain, this.domainId, this.level, this.parentId, this.state, this.type, this.username);
        }
    }
}

