/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import java.util.Date;

public class StoragePool
implements Comparable<StoragePool> {
    private long id;
    private String name;
    private String path;
    private String tags;
    private State state;
    private Type type;
    @SerializedName(value="zoneid")
    private long zoneId;
    @SerializedName(value="zonename")
    private String zoneName;
    @SerializedName(value="podid")
    private long podId;
    @SerializedName(value="podname")
    private String podName;
    @SerializedName(value="clusterid")
    private long clusterId;
    @SerializedName(value="clustername")
    private String clusterName;
    private Date created;
    @SerializedName(value="disksizeallocated")
    private long diskSizeAllocated;
    @SerializedName(value="disksizetotal")
    private long diskSizeTotal;
    @SerializedName(value="ipaddress")
    private String ipAddress;
    @SerializedName(value="jobid")
    private Long jobId;
    @SerializedName(value="jobstatus")
    private String jobStatus;

    public static Builder builder() {
        return new Builder();
    }

    StoragePool() {
    }

    public StoragePool(long id, String name, String path, String tags, State state, Type type, long zoneId, String zoneName, long podId, String podName, long clusterId, String clusterName, Date created, long diskSizeAllocated, long diskSizeTotal, String ipAddress, Long jobId, String jobStatus) {
        this.id = id;
        this.name = name;
        this.path = path;
        this.tags = tags;
        this.state = state;
        this.type = type;
        this.zoneId = zoneId;
        this.zoneName = zoneName;
        this.podId = podId;
        this.podName = podName;
        this.clusterId = clusterId;
        this.clusterName = clusterName;
        this.created = created;
        this.diskSizeAllocated = diskSizeAllocated;
        this.diskSizeTotal = diskSizeTotal;
        this.ipAddress = ipAddress;
        this.jobId = jobId;
        this.jobStatus = jobStatus;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getTags() {
        return this.tags;
    }

    public State getState() {
        return this.state;
    }

    public Type getType() {
        return this.type;
    }

    public long getZoneId() {
        return this.zoneId;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public long getPodId() {
        return this.podId;
    }

    public String getPodName() {
        return this.podName;
    }

    public long getClusterId() {
        return this.clusterId;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public Date getCreated() {
        return this.created;
    }

    public long getDiskSizeAllocated() {
        return this.diskSizeAllocated;
    }

    public long getDiskSizeTotal() {
        return this.diskSizeTotal;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public Long getJobId() {
        return this.jobId;
    }

    public String getJobStatus() {
        return this.jobStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoragePool that = (StoragePool)o;
        if (this.clusterId != that.clusterId) {
            return false;
        }
        if (this.diskSizeAllocated != that.diskSizeAllocated) {
            return false;
        }
        if (this.diskSizeTotal != that.diskSizeTotal) {
            return false;
        }
        if (this.id != that.id) {
            return false;
        }
        if (this.podId != that.podId) {
            return false;
        }
        if (this.zoneId != that.zoneId) {
            return false;
        }
        if (this.clusterName != null ? !this.clusterName.equals(that.clusterName) : that.clusterName != null) {
            return false;
        }
        if (this.created != null ? !this.created.equals(that.created) : that.created != null) {
            return false;
        }
        if (this.ipAddress != null ? !this.ipAddress.equals(that.ipAddress) : that.ipAddress != null) {
            return false;
        }
        if (this.jobId != null ? !this.jobId.equals(that.jobId) : that.jobId != null) {
            return false;
        }
        if (this.jobStatus != null ? !this.jobStatus.equals(that.jobStatus) : that.jobStatus != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (this.podName != null ? !this.podName.equals(that.podName) : that.podName != null) {
            return false;
        }
        if (this.state != that.state) {
            return false;
        }
        if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        return !(this.zoneName != null ? !this.zoneName.equals(that.zoneName) : that.zoneName != null);
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (int)(this.zoneId ^ this.zoneId >>> 32);
        result = 31 * result + (this.zoneName != null ? this.zoneName.hashCode() : 0);
        result = 31 * result + (int)(this.podId ^ this.podId >>> 32);
        result = 31 * result + (this.podName != null ? this.podName.hashCode() : 0);
        result = 31 * result + (int)(this.clusterId ^ this.clusterId >>> 32);
        result = 31 * result + (this.clusterName != null ? this.clusterName.hashCode() : 0);
        result = 31 * result + (this.created != null ? this.created.hashCode() : 0);
        result = 31 * result + (int)(this.diskSizeAllocated ^ this.diskSizeAllocated >>> 32);
        result = 31 * result + (int)(this.diskSizeTotal ^ this.diskSizeTotal >>> 32);
        result = 31 * result + (this.ipAddress != null ? this.ipAddress.hashCode() : 0);
        result = 31 * result + (this.jobId != null ? this.jobId.hashCode() : 0);
        result = 31 * result + (this.jobStatus != null ? this.jobStatus.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "StoragePool{id=" + this.id + ", name='" + this.name + '\'' + ", path='" + this.path + '\'' + ", tags='" + this.tags + '\'' + ", state=" + (Object)((Object)this.state) + ", type=" + (Object)((Object)this.type) + ", zoneId=" + this.zoneId + ", zoneName='" + this.zoneName + '\'' + ", podId=" + this.podId + ", podName='" + this.podName + '\'' + ", clusterId=" + this.clusterId + ", clusterName='" + this.clusterName + '\'' + ", created=" + this.created + ", diskSizeAllocated=" + this.diskSizeAllocated + ", diskSizeTotal=" + this.diskSizeTotal + ", ipAddress='" + this.ipAddress + '\'' + ", jobId=" + this.jobId + ", jobStatus='" + this.jobStatus + '\'' + '}';
    }

    @Override
    public int compareTo(StoragePool other) {
        return Long.valueOf(this.id).compareTo(other.id);
    }

    public static class Builder {
        private long id;
        private String name;
        private String path;
        private String tags;
        private State state;
        private Type type;
        private long zoneId;
        private String zoneName;
        private long podId;
        private String podName;
        private long clusterId;
        private String clusterName;
        private Date created;
        private long diskSizeAllocated;
        private long diskSizeTotal;
        private String ipAddress;
        private Long jobId;
        private String jobStatus;

        private Builder() {
        }

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder tags(String tags) {
            this.tags = tags;
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder zoneId(long zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public Builder podId(long podId) {
            this.podId = podId;
            return this;
        }

        public Builder podName(String podName) {
            this.podName = podName;
            return this;
        }

        public Builder clusterId(long clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            return this;
        }

        public Builder diskSizeAllocated(long diskSizeAllocated) {
            this.diskSizeAllocated = diskSizeAllocated;
            return this;
        }

        public Builder diskSizeTotal(long diskSizeTotal) {
            this.diskSizeTotal = diskSizeTotal;
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public Builder jobId(Long jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        public StoragePool build() {
            return new StoragePool(this.id, this.name, this.path, this.tags, this.state, this.type, this.zoneId, this.zoneName, this.podId, this.podName, this.clusterId, this.clusterName, this.created, this.diskSizeAllocated, this.diskSizeTotal, this.ipAddress, this.jobId, this.jobStatus);
        }
    }

    public static enum Type {
        FILESYSTEM,
        NETWORK_FILESYSTEM,
        ISCSI_LUN,
        ISCSI,
        ISO,
        LVM,
        CLVM,
        SHARED_MOUNT_POINT,
        VMFS,
        PRE_SETUP,
        EXT,
        OCFS2,
        UNRECOGNIZED;


        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }

        public static Type fromValue(String type) {
            try {
                return Type.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)type, (Object)"type")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static enum State {
        UP,
        PREPARE_FOR_MAINTENANCE,
        ERROR_IN_MAINTENANCE,
        CANCEL_MAINTENANCE,
        MAINTENANCE,
        REMOVED,
        UNRECOGNIZED;


        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }

        public static State fromValue(String type) {
            try {
                return State.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)type, (Object)"type")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

