/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.PublicIPAddress;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.cloudstack.functions.ReturnVoidOnNotFoundOr404OrUnableToFindAccountOwner;
import org.jclouds.cloudstack.options.AssociateIPAddressOptions;
import org.jclouds.cloudstack.options.ListPublicIPAddressesOptions;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.OnlyElement;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Unwrap;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;

@RequestFilters(value={AuthenticationFilter.class})
@QueryParams(keys={"response"}, values={"json"})
public interface AddressAsyncClient {
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listPublicIpAddresses", "true"})
    @SelectJson(value="publicipaddress")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<PublicIPAddress>> listPublicIPAddresses(ListPublicIPAddressesOptions ... var1);

    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listPublicIpAddresses", "true"})
    @SelectJson(value="publicipaddress")
    @OnlyElement
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<PublicIPAddress> getPublicIPAddress(@QueryParam(value="id") String var1);

    @GET
    @QueryParams(keys={"command"}, values={"associateIpAddress"})
    @Unwrap
    @Consumes(value={"application/json"})
    public ListenableFuture<AsyncCreateResponse> associateIPAddressInZone(@QueryParam(value="zoneid") String var1, AssociateIPAddressOptions ... var2);

    @GET
    @QueryParams(keys={"command"}, values={"disassociateIpAddress"})
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404OrUnableToFindAccountOwner.class)
    public ListenableFuture<Void> disassociateIPAddress(@QueryParam(value="id") String var1);
}

