/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.cloudstack.options.AssignVirtualMachineOptions;
import org.jclouds.cloudstack.options.DeployVirtualMachineOptions;
import org.jclouds.cloudstack.options.ListVirtualMachinesOptions;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.OnlyElement;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Unwrap;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;

@RequestFilters(value={AuthenticationFilter.class})
@QueryParams(keys={"response"}, values={"json"})
public interface VirtualMachineAsyncClient {
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listVirtualMachines", "true"})
    @SelectJson(value="virtualmachine")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<VirtualMachine>> listVirtualMachines(ListVirtualMachinesOptions ... var1);

    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listVirtualMachines", "true"})
    @SelectJson(value="virtualmachine")
    @OnlyElement
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<VirtualMachine> getVirtualMachine(@QueryParam(value="id") String var1);

    @GET
    @QueryParams(keys={"command"}, values={"deployVirtualMachine"})
    @Unwrap
    @Consumes(value={"application/json"})
    public ListenableFuture<AsyncCreateResponse> deployVirtualMachineInZone(@QueryParam(value="zoneid") String var1, @QueryParam(value="serviceofferingid") String var2, @QueryParam(value="templateid") String var3, DeployVirtualMachineOptions ... var4);

    @GET
    @QueryParams(keys={"command"}, values={"rebootVirtualMachine"})
    @SelectJson(value="jobid")
    @Consumes(value={"application/json"})
    public ListenableFuture<String> rebootVirtualMachine(@QueryParam(value="id") String var1);

    @GET
    @QueryParams(keys={"command"}, values={"startVirtualMachine"})
    @SelectJson(value="jobid")
    @Consumes(value={"application/json"})
    public ListenableFuture<String> startVirtualMachine(@QueryParam(value="id") String var1);

    @GET
    @QueryParams(keys={"command"}, values={"stopVirtualMachine"})
    @SelectJson(value="jobid")
    @Consumes(value={"application/json"})
    public ListenableFuture<String> stopVirtualMachine(@QueryParam(value="id") String var1);

    @GET
    @QueryParams(keys={"command"}, values={"resetPasswordForVirtualMachine"})
    @SelectJson(value="jobid")
    @Consumes(value={"application/json"})
    public ListenableFuture<String> resetPasswordForVirtualMachine(@QueryParam(value="id") String var1);

    @GET
    @QueryParams(keys={"command"}, values={"getVMPassword"})
    @SelectJson(value="encryptedpassword")
    @Consumes(value={"application/json"})
    public ListenableFuture<String> getEncryptedPasswordForVirtualMachine(@QueryParam(value="id") String var1);

    @GET
    @QueryParams(keys={"command"}, values={"changeServiceForVirtualMachine"})
    @SelectJson(value="jobid")
    @Consumes(value={"application/json"})
    public ListenableFuture<String> changeServiceForVirtualMachine(@QueryParam(value="id") String var1);

    @GET
    @QueryParams(keys={"command"}, values={"updateVirtualMachine"})
    @SelectJson(value="jobid")
    @Consumes(value={"application/json"})
    public ListenableFuture<String> updateVirtualMachine(@QueryParam(value="id") String var1);

    @GET
    @QueryParams(keys={"command"}, values={"destroyVirtualMachine"})
    @SelectJson(value="jobid")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<String> destroyVirtualMachine(@QueryParam(value="id") String var1);

    @GET
    @QueryParams(keys={"command"}, values={"assignVirtualMachine"})
    @SelectJson(value="jobid")
    @Consumes(value={"application/json"})
    public ListenableFuture<VirtualMachine> assignVirtualMachine(@QueryParam(value="virtualmachineid") String var1, AssignVirtualMachineOptions ... var2);
}

