/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.filters;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Multimap;
import com.google.common.io.InputSupplier;
import java.util.Map;
import javax.annotation.Resource;
import javax.crypto.Mac;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.internal.SignatureWire;
import org.jclouds.http.utils.Queries;
import org.jclouds.io.InputSuppliers;
import org.jclouds.logging.Logger;
import org.jclouds.rest.RequestSigner;
import org.jclouds.rest.annotations.Credential;
import org.jclouds.rest.annotations.Identity;
import org.jclouds.util.Strings2;

@Singleton
public class QuerySigner
implements AuthenticationFilter,
RequestSigner {
    private final SignatureWire signatureWire;
    private final String accessKey;
    private final String secretKey;
    private final Crypto crypto;
    private final HttpUtils utils;
    private final Provider<UriBuilder> builder;
    @Resource
    @Named(value="jclouds.signature")
    private Logger signatureLog = Logger.NULL;

    @Inject
    public QuerySigner(SignatureWire signatureWire, @Identity String accessKey, @Credential String secretKey, Crypto crypto, HttpUtils utils, Provider<UriBuilder> builder) {
        this.signatureWire = signatureWire;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.crypto = crypto;
        this.utils = utils;
        this.builder = builder;
    }

    public HttpRequest filter(HttpRequest request) throws HttpException {
        Preconditions.checkNotNull((Object)request, (Object)"request must be present");
        Multimap decodedParams = Queries.parseQueryToMap((String)request.getEndpoint().getRawQuery());
        this.addSigningParams((Multimap<String, String>)decodedParams);
        String stringToSign = this.createStringToSign(request, (Multimap<String, String>)decodedParams);
        String signature = this.sign(stringToSign);
        this.addSignature((Multimap<String, String>)decodedParams, signature);
        request = request.toBuilder().endpoint(((UriBuilder)this.builder.get()).uri(request.getEndpoint()).replaceQuery(Queries.makeQueryLine((Multimap)decodedParams, null, (char[])new char[0])).build(new Object[0])).build();
        this.utils.logRequest(this.signatureLog, request, "<<");
        return request;
    }

    @VisibleForTesting
    void addSignature(Multimap<String, String> params, String signature) {
        params.replaceValues((Object)"signature", (Iterable)ImmutableList.of((Object)signature));
    }

    @VisibleForTesting
    public String sign(String stringToSign) {
        String signature;
        try {
            signature = CryptoStreams.base64((byte[])CryptoStreams.mac((InputSupplier)InputSuppliers.of((String)stringToSign), (Mac)this.crypto.hmacSHA1(this.secretKey.getBytes())));
            if (this.signatureWire.enabled()) {
                this.signatureWire.input(Strings2.toInputStream((String)signature));
            }
        }
        catch (Exception e) {
            throw new HttpException("error signing request", (Throwable)e);
        }
        return signature;
    }

    @VisibleForTesting
    public String createStringToSign(HttpRequest request, Multimap<String, String> decodedParams) {
        this.utils.logRequest(this.signatureLog, request, ">>");
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        for (Map.Entry entry : decodedParams.entries()) {
            builder.add((Object)((String)entry.getKey() + "=" + Strings2.urlEncode((String)((String)entry.getValue()), (char[])new char[0])));
        }
        String stringToSign = Joiner.on((char)'&').join((Iterable)builder.build()).toLowerCase();
        if (this.signatureWire.enabled()) {
            this.signatureWire.output((Object)stringToSign);
        }
        return stringToSign;
    }

    @VisibleForTesting
    void addSigningParams(Multimap<String, String> params) {
        params.replaceValues((Object)"apiKey", (Iterable)ImmutableList.of((Object)this.accessKey));
        params.removeAll((Object)"signature");
    }

    public String createStringToSign(HttpRequest input) {
        Multimap decodedParams = Queries.parseQueryToMap((String)input.getEndpoint().getQuery());
        this.addSigningParams((Multimap<String, String>)decodedParams);
        return this.createStringToSign(input, (Multimap<String, String>)decodedParams);
    }
}

