/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.devtools.service;

import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jeeplus.common.constant.CommonConstants;
import com.jeeplus.core.domain.BaseEntity;
import com.jeeplus.core.query.QueryWrapperGenerator;
import com.jeeplus.devtools.domain.Table;
import com.jeeplus.devtools.domain.TableColumn;
import com.jeeplus.devtools.mapper.DataBaseDictMapper;
import com.jeeplus.devtools.mapper.TableMapper;
import com.jeeplus.devtools.service.TableColumnService;
import com.jeeplus.devtools.service.dto.TableColumnDTO;
import com.jeeplus.devtools.service.dto.TableDTO;
import com.jeeplus.devtools.service.mapstruct.TableColumnWrapper;
import com.jeeplus.devtools.service.mapstruct.TableWrapper;
import com.jeeplus.devtools.util.StringUtil;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.HashSet;
import java.util.List;
import net.sf.jsqlparser.parser.CCJSqlParserManager;
import net.sf.jsqlparser.statement.select.Select;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service
public class TableService
extends ServiceImpl<TableMapper, Table> {
    @Autowired
    private TableColumnService tableColumnService;
    @Autowired
    private DataBaseDictMapper dataBaseDictMapper;

    public IPage<TableDTO> findPage(Page<TableDTO> page, QueryWrapper queryWrapper) {
        queryWrapper.eq((Object)"a.del_flag", (Object)CommonConstants.NOT_DELETED);
        return ((TableMapper)this.baseMapper).findList(page, queryWrapper);
    }

    public List<TableDTO> findList(TableDTO tableDTO) throws Exception {
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)((Object)tableDTO), TableDTO.class);
        queryWrapper.eq((Object)"a.del_flag", (Object)CommonConstants.NOT_DELETED);
        Page page = new Page(1L, -1L);
        return ((TableMapper)this.baseMapper).findList((Page<TableDTO>)page, queryWrapper).getRecords();
    }

    @DS(value="#tableDTO.dataSource.enName")
    public List<TableDTO> findTableListFormDb(TableDTO tableDTO) {
        return this.dataBaseDictMapper.findTableList(tableDTO);
    }

    public boolean checkTableName(TableDTO tableDTO) {
        if (StrUtil.isBlank((CharSequence)tableDTO.getName())) {
            return true;
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Table::getName, (Object)tableDTO.getName())).eq(Table::getDataSourceId, (Object)tableDTO.getDataSource().getId())).list();
        return list.size() == 0;
    }

    @DS(value="#tableDTO.dataSource.enName")
    public boolean checkTableNameFromDB(TableDTO tableDTO) {
        if (StrUtil.isBlank((CharSequence)tableDTO.getName())) {
            return true;
        }
        List<TableDTO> list = this.dataBaseDictMapper.findTableListByName(tableDTO);
        return list.size() == 0;
    }

    @DS(value="#tableDTO.dataSource.enName")
    public TableDTO getTableFormDb(TableDTO tableDTO) {
        List<TableDTO> list;
        if (StrUtil.isNotBlank((CharSequence)tableDTO.getName()) && (list = this.dataBaseDictMapper.findTableListByName(tableDTO)).size() > 0) {
            boolean b;
            if (StrUtil.isBlank((CharSequence)tableDTO.getId())) {
                tableDTO = list.get(0);
                if (StrUtil.isBlank((CharSequence)tableDTO.getComments())) {
                    tableDTO.setComments(tableDTO.getName());
                }
                tableDTO.setClassName(StringUtil.toCapitalizeCamelCase(tableDTO.getName()));
            }
            List<TableColumnDTO> columnList = this.dataBaseDictMapper.findTableColumnList(tableDTO);
            for (TableColumnDTO column : columnList) {
                b = false;
                for (TableColumnDTO e : tableDTO.getColumnList()) {
                    if (e.getName() == null || !e.getName().equals(column.getName())) continue;
                    b = true;
                }
                if (b) continue;
                tableDTO.getColumnList().add(column);
            }
            for (TableColumnDTO e : tableDTO.getColumnList()) {
                b = false;
                for (TableColumnDTO column : columnList) {
                    if (!column.getName().equals(e.getName())) continue;
                    b = true;
                }
                if (b) continue;
                e.setDelFlag(1);
            }
            List<String> pks = this.dataBaseDictMapper.findTablePK(tableDTO);
            tableDTO.setPkList(pks);
            if (pks.size() > 0) {
                for (TableColumnDTO column : tableDTO.getColumnList()) {
                    if (!pks.get(0).equalsIgnoreCase(column.getName())) continue;
                    if (column.getJdbcType().toLowerCase().contains("integer") || column.getJdbcType().toLowerCase().contains("int")) {
                        tableDTO.setIdType("2");
                        continue;
                    }
                    tableDTO.setIdType("1");
                }
            }
        }
        return tableDTO;
    }

    public void saveNewTable(TableDTO tableDTO) {
        tableDTO.setIsSync("0");
        TableDTO oldTable = null;
        Table table = TableWrapper.INSTANCE.toEntity(tableDTO);
        if (StrUtil.isBlank((CharSequence)tableDTO.getId())) {
            super.save((Object)table);
        } else {
            oldTable = this.getById(tableDTO.getId());
            super.updateById((Object)table);
        }
        HashSet<String> existSet = new HashSet<String>();
        for (TableColumnDTO columnDTO : tableDTO.getColumnList()) {
            TableColumn column = TableColumnWrapper.INSTANCE.toEntity(columnDTO);
            column.setTableId(table.getId());
            if (StrUtil.isBlank((CharSequence)column.getId())) {
                this.tableColumnService.save((Object)column);
                continue;
            }
            existSet.add(column.getId());
            this.tableColumnService.updateById((Object)column);
        }
        if (oldTable != null) {
            List<TableColumnDTO> oldColummns = oldTable.getAllColumnList();
            for (TableColumnDTO oldColumn : oldColummns) {
                if (existSet.contains(oldColumn.getId())) continue;
                this.tableColumnService.removeById((Serializable)((Object)oldColumn.getId()));
            }
        }
    }

    public void save(TableDTO tableDTO) {
        boolean isSync = true;
        TableDTO oldTableDTO = null;
        if (StrUtil.isBlank((CharSequence)tableDTO.getId())) {
            isSync = false;
        } else {
            oldTableDTO = this.getById(tableDTO.getId());
            if (!(oldTableDTO.getColumnList().size() == tableDTO.getColumnList().size() && oldTableDTO.getName().equals(tableDTO.getName()) && oldTableDTO.getComments().equals(tableDTO.getComments()) && oldTableDTO.getIdType().equals(tableDTO.getIdType()))) {
                isSync = false;
            } else {
                for (TableColumnDTO columnDTO : tableDTO.getColumnList()) {
                    if (StrUtil.isBlank((CharSequence)columnDTO.getId())) {
                        isSync = false;
                        continue;
                    }
                    Object oldColumn = (TableColumn)((Object)this.tableColumnService.getById((Serializable)((Object)columnDTO.getId())));
                    if (((TableColumn)((Object)oldColumn)).getName().equals(columnDTO.getName()) && ((TableColumn)((Object)oldColumn)).getJdbcType().equals(columnDTO.getJdbcType()) && ((TableColumn)((Object)oldColumn)).getIsPk().equals(columnDTO.getIsPk()) && ((TableColumn)((Object)oldColumn)).getComments().equals(columnDTO.getComments())) continue;
                    isSync = false;
                }
            }
        }
        if (!isSync) {
            tableDTO.setIsSync("0");
        }
        Table table = TableWrapper.INSTANCE.toEntity(tableDTO);
        if (StrUtil.isBlank((CharSequence)tableDTO.getId())) {
            super.save((Object)table);
        } else {
            table.setOldName(oldTableDTO.getOldName());
            table.setOldComments(oldTableDTO.getOldComments());
            table.setOldIdType(oldTableDTO.getOldIdType());
            super.updateById((Object)table);
        }
        HashSet<String> existSet = new HashSet<String>();
        for (TableColumnDTO columnDTO : tableDTO.getColumnList()) {
            TableColumn column = TableColumnWrapper.INSTANCE.toEntity(columnDTO);
            if (StrUtil.isBlank((CharSequence)column.getId())) {
                column.setTableId(table.getId());
                this.tableColumnService.save((Object)column);
                continue;
            }
            existSet.add(column.getId());
            TableColumn oldColumn = (TableColumn)((Object)this.tableColumnService.getById((Serializable)((Object)column.getId())));
            column.setOldComments(oldColumn.getOldComments());
            column.setOldIsPk(oldColumn.getOldIsPk());
            column.setOldJdbcType(oldColumn.getOldJdbcType());
            column.setOldName(oldColumn.getOldName());
            this.tableColumnService.updateById((Object)column);
        }
        if (oldTableDTO != null) {
            List<TableColumnDTO> oldTableDTOColumnList = oldTableDTO.getColumnList();
            for (TableColumnDTO oldColumnDTO : oldTableDTOColumnList) {
                if (existSet.contains(oldColumnDTO.getId())) continue;
                if (oldColumnDTO.getOldName() != null) {
                    ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.tableColumnService.lambdaUpdate().eq(BaseEntity::getId, (Object)oldColumnDTO.getId())).set(BaseEntity::getDelFlag, (Object)1)).update();
                    continue;
                }
                this.tableColumnService.removeById((Serializable)((Object)oldColumnDTO.getId()));
            }
        }
    }

    public void syncSave(TableDTO tableDTO) {
        tableDTO.setIsSync("1");
        tableDTO.setOldName(tableDTO.getName());
        tableDTO.setOldComments(tableDTO.getComments());
        tableDTO.setOldIdType(tableDTO.getIdType());
        for (TableColumnDTO columnDTO : tableDTO.getAllColumnList()) {
            if (1 == columnDTO.getDelFlag()) {
                this.tableColumnService.removeById((Serializable)((Object)columnDTO.getId()));
                continue;
            }
            columnDTO.setOldComments(columnDTO.getComments());
            columnDTO.setOldIsPk(columnDTO.getIsPk());
            columnDTO.setOldJdbcType(columnDTO.getJdbcType());
            columnDTO.setOldName(columnDTO.getName());
            this.tableColumnService.updateById((Object)TableColumnWrapper.INSTANCE.toEntity(columnDTO));
        }
        super.updateById((Object)TableWrapper.INSTANCE.toEntity(tableDTO));
    }

    public void saveFromDB(TableDTO tableDTO) {
        tableDTO.setOldName(tableDTO.getName());
        tableDTO.setOldComments(tableDTO.getComments());
        tableDTO.setOldIdType(tableDTO.getIdType());
        Table table = TableWrapper.INSTANCE.toEntity(tableDTO);
        super.save((Object)table);
        for (TableColumnDTO columnDTO : tableDTO.getColumnList()) {
            TableColumn column = TableColumnWrapper.INSTANCE.toEntity(columnDTO);
            column.setTableId(table.getId());
            column.setId(null);
            column.setOldComments(column.getComments());
            column.setOldIsPk(column.getIsPk());
            column.setOldJdbcType(column.getJdbcType());
            column.setOldName(column.getName());
            this.tableColumnService.save((Object)column);
        }
    }

    public void removeById(String id) {
        super.removeById((Serializable)((Object)id));
        ((LambdaUpdateChainWrapper)this.tableColumnService.lambdaUpdate().eq(TableColumn::getTableId, (Object)id)).remove();
    }

    @DS(value="#tableDTO.dataSource.enName")
    public void buildTable(TableDTO tableDTO, String sql) {
        if (StrUtil.isNotBlank((CharSequence)sql)) {
            ((TableMapper)this.baseMapper).buildTable(sql);
        }
    }

    @DS(value="#tableDTO.dataSource.enName")
    public void buildAllTable(TableDTO tableDTO, String sql) {
        String[] statements;
        for (String statement : statements = sql.split(";")) {
            if (!StrUtil.isNotBlank((CharSequence)statement)) continue;
            ((TableMapper)this.baseMapper).buildTable(statement);
        }
    }

    public void copyTable(TableDTO sourceTableDTO, String newTableName) {
        Table table = TableWrapper.INSTANCE.toEntity(sourceTableDTO);
        table.setId(null);
        table.setName(newTableName);
        table.setOldName(null);
        table.setIsSync("0");
        table.setClassName(StringUtil.toCapitalizeCamelCase(newTableName));
        this.save((Object)table);
        sourceTableDTO.getColumnList().forEach(tableColumnDTO -> {
            TableColumn tableColumn = TableColumnWrapper.INSTANCE.toEntity((TableColumnDTO)((Object)tableColumnDTO));
            tableColumn.setId(null);
            tableColumn.setTableId(table.getId());
            this.tableColumnService.save((Object)tableColumn);
        });
    }

    public TableDTO getById(String id) {
        TableDTO tableDTO = ((TableMapper)this.baseMapper).findById(id);
        if (tableDTO.getIdType() == null) {
            tableDTO.setIdType("1");
        }
        tableDTO.setColumnList(this.tableColumnService.findList(id));
        tableDTO.setAllColumnList(this.tableColumnService.findListAllStatus(id));
        return tableDTO;
    }

    public static void main(String[] args) {
        String sql = "SELECT t.table_name  FROM information_schema.`TABLES` t WHERE    t.TABLE_SCHEMA = (select database() ) ";
        try {
            CCJSqlParserManager parserManager = new CCJSqlParserManager();
            Select select = (Select)parserManager.parse((Reader)new StringReader(sql));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

