/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.github;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.apache.tika.Tika;
import org.apache.tika.mime.MediaType;
import org.jreleaser.model.JReleaserVersion;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.StringUtils;
import org.kohsuke.github.GHAsset;
import org.kohsuke.github.GHDiscussion;
import org.kohsuke.github.GHException;
import org.kohsuke.github.GHFileNotFoundException;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHMilestone;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHRelease;
import org.kohsuke.github.GHReleaseBuilder;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHTeam;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.github.HttpConnector;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.extras.ImpatientHttpConnector;

class Github {
    static final String ENDPOINT = "https://api.github.com";
    private final Tika tika = new Tika();
    private final JReleaserLogger logger;
    private final GitHub github;

    Github(JReleaserLogger logger, String username, String password, int connectTimeout, int readTimeout) throws IOException {
        this(logger, ENDPOINT, username, password, connectTimeout, readTimeout);
    }

    Github(JReleaserLogger logger, String endpoint, String username, String password, int connectTimeout, int readTimeout) throws IOException {
        this.logger = logger;
        if (StringUtils.isBlank((String)endpoint)) {
            endpoint = ENDPOINT;
        }
        this.github = new GitHubBuilder().withConnector((HttpConnector)new JReleaserHttpConnector(connectTimeout, readTimeout)).withEndpoint(endpoint).withOAuthToken(password, username).build();
    }

    GHRepository findRepository(String owner, String repo) throws IOException {
        this.logger.debug("lookup repository {}/{}", new Object[]{owner, repo});
        try {
            return this.github.getRepository(owner + "/" + repo);
        }
        catch (GHFileNotFoundException e) {
            return null;
        }
    }

    GHRepository createRepository(String owner, String repo) throws IOException {
        this.logger.debug("creating repository {}/{}", new Object[]{owner, repo});
        GHOrganization organization = this.resolveOrganization(owner);
        if (null != organization) {
            return organization.createRepository(repo).create();
        }
        return this.github.createRepository(repo).create();
    }

    Optional<GHMilestone> findMilestoneByName(String owner, String repo, String milestoneName) throws IOException {
        this.logger.debug("lookup milestone '{}' on {}/{}", new Object[]{milestoneName, owner, repo});
        GHRepository repository = this.findRepository(owner, repo);
        PagedIterable milestones = repository.listMilestones(GHIssueState.OPEN);
        return StreamSupport.stream(milestones.spliterator(), false).filter(m -> milestoneName.equals(m.getTitle())).findFirst();
    }

    void closeMilestone(String owner, String repo, GHMilestone milestone) throws IOException {
        this.logger.debug("closing milestone '{}' on {}/{}", new Object[]{milestone.getTitle(), owner, repo});
        milestone.close();
    }

    GHRelease findReleaseByTag(String repo, String tagName) throws IOException {
        this.logger.debug("fetching release on {} with tag {}", new Object[]{repo, tagName});
        return this.github.getRepository(repo).getReleaseByTagName(tagName);
    }

    void deleteTag(String repo, String tagName) throws IOException {
        this.logger.debug("deleting tag {} from {}", new Object[]{tagName, repo});
        this.github.getRepository(repo).getRef("refs/tags/" + tagName).delete();
    }

    GHReleaseBuilder createRelease(String repo, String tagName) throws IOException {
        this.logger.debug("creating release on {} with tag {}", new Object[]{repo, tagName});
        return this.github.getRepository(repo).createRelease(tagName);
    }

    void uploadAssets(GHRelease release, List<Path> assets) throws IOException {
        for (Path asset : assets) {
            if (0L == asset.toFile().length() || !Files.exists(asset, new LinkOption[0])) continue;
            this.logger.info(" - uploading {}", new Object[]{asset.getFileName().toString()});
            GHAsset ghasset = release.uploadAsset(asset.toFile(), MediaType.parse((String)this.tika.detect(asset)).toString());
            if ("uploaded".equalsIgnoreCase(ghasset.getState())) continue;
            this.logger.warn(" x failed to upload {}", new Object[]{asset.getFileName()});
        }
    }

    Optional<GHDiscussion> findDiscussion(String organization, String team, String title) throws IOException {
        GHTeam ghTeam = this.resolveTeam(organization, team);
        try {
            return StreamSupport.stream(ghTeam.listDiscussions().spliterator(), false).filter(d -> title.equals(d.getTitle())).findFirst();
        }
        catch (GHException ghe) {
            if (ghe.getCause() instanceof GHFileNotFoundException) {
                return Optional.empty();
            }
            throw ghe;
        }
    }

    GHDiscussion createDiscussion(String organization, String team, String title, String message) throws IOException {
        GHTeam ghTeam = this.resolveTeam(organization, team);
        return ((GHDiscussion.Creator)ghTeam.createDiscussion(title).body(message)).done();
    }

    private GHOrganization resolveOrganization(String name) throws IOException {
        try {
            return this.github.getOrganization(name);
        }
        catch (GHFileNotFoundException ignored) {
            return null;
        }
    }

    private GHTeam resolveTeam(String organization, String team) throws IOException {
        GHOrganization ghOrganization = null;
        try {
            ghOrganization = this.github.getOrganization(organization);
        }
        catch (GHFileNotFoundException e) {
            throw new IllegalStateException("Organization '" + organization + "' does not exist");
        }
        GHTeam ghTeam = null;
        try {
            ghTeam = ghOrganization.getTeamByName(team);
        }
        catch (IOException e) {
            throw new IllegalStateException("Team '" + team + "' does not exist");
        }
        if (null == ghTeam) {
            throw new IllegalStateException("Team '" + team + "' does not exist");
        }
        return ghTeam;
    }

    private static class JReleaserHttpConnector
    extends ImpatientHttpConnector {
        public JReleaserHttpConnector(int connectTimeout, int readTimeout) {
            super(HttpConnector.DEFAULT, connectTimeout * 1000, readTimeout * 1000);
        }

        public HttpURLConnection connect(URL url) throws IOException {
            HttpURLConnection connection = super.connect(url);
            connection.addRequestProperty("User-Agent", "JReleaser/" + JReleaserVersion.getPlainVersion());
            return connection;
        }
    }
}

