/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.github;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.releaser.spi.ReleaseException;
import org.jreleaser.model.releaser.spi.Releaser;
import org.jreleaser.model.releaser.spi.Repository;
import org.jreleaser.sdk.git.GitSdk;
import org.jreleaser.sdk.github.Github;
import org.kohsuke.github.GHMilestone;
import org.kohsuke.github.GHRelease;
import org.kohsuke.github.GHRepository;

public class GithubReleaser
implements Releaser {
    private final JReleaserContext context;
    private final List<Path> assets = new ArrayList<Path>();

    GithubReleaser(JReleaserContext context, List<Path> assets) {
        this.context = context;
        this.assets.addAll(assets);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void release() throws ReleaseException {
        org.jreleaser.model.Github github = this.context.getModel().getRelease().getGithub();
        this.context.getLogger().info("Releasing to {}", new Object[]{github.getResolvedRepoUrl(this.context.getModel())});
        String tagName = github.getEffectiveTagName(this.context.getModel());
        try {
            String changelog = this.context.getChangelog();
            Github api = new Github(this.context.getLogger(), github.getUsername(), github.getResolvedToken(), github.getConnectTimeout(), github.getReadTimeout());
            this.context.getLogger().debug("looking up release with tag {} at repository {}", new Object[]{tagName, github.getCanonicalRepoName()});
            GHRelease release = api.findReleaseByTag(github.getCanonicalRepoName(), tagName);
            if (null != release) {
                this.context.getLogger().debug("release {} exists", new Object[]{tagName});
                if (github.isOverwrite()) {
                    this.context.getLogger().debug("deleting release {}", new Object[]{tagName});
                    if (!this.context.isDryrun()) {
                        release.delete();
                    }
                    this.context.getLogger().debug("creating release {}", new Object[]{tagName});
                    this.createRelease(api, tagName, changelog, this.context.getModel().getProject().isSnapshot());
                    return;
                } else {
                    if (!github.isUpdate()) throw new IllegalStateException("Github release failed because release " + tagName + " already exists. overwrite = false; update = false");
                    this.context.getLogger().debug("updating release {}", new Object[]{tagName});
                    if (this.context.isDryrun()) return;
                    api.uploadAssets(release, this.assets);
                }
                return;
            } else {
                this.context.getLogger().debug("release {} does not exist", new Object[]{tagName});
                this.context.getLogger().debug("creating release {}", new Object[]{tagName});
                this.createRelease(api, tagName, changelog, this.context.getModel().getProject().isSnapshot());
            }
            return;
        }
        catch (IOException | IllegalStateException e) {
            this.context.getLogger().trace((Throwable)e);
            throw new ReleaseException((Throwable)e);
        }
    }

    public Repository maybeCreateRepository(String owner, String repo, String password) throws IOException {
        org.jreleaser.model.Github github = this.context.getModel().getRelease().getGithub();
        this.context.getLogger().debug("looking up {}/{}", new Object[]{owner, repo});
        Github api = new Github(this.context.getLogger(), github.getApiEndpoint(), password, github.getConnectTimeout(), github.getReadTimeout());
        GHRepository repository = api.findRepository(owner, repo);
        if (null == repository) {
            repository = api.createRepository(owner, repo);
        }
        return new Repository(Repository.Kind.GITHUB, owner, repo, repository.getUrl().toExternalForm(), repository.getHttpTransportUrl());
    }

    private void createRelease(Github api, String tagName, String changelog, boolean deleteTags) throws IOException {
        Optional<GHMilestone> milestone;
        org.jreleaser.model.Github github = this.context.getModel().getRelease().getGithub();
        if (this.context.isDryrun()) {
            for (Path asset : this.assets) {
                if (0L == asset.toFile().length() || !Files.exists(asset, new LinkOption[0])) continue;
                this.context.getLogger().info(" - uploading {}", new Object[]{asset.getFileName().toString()});
            }
            return;
        }
        if (deleteTags) {
            this.deleteTags(api, github.getCanonicalRepoName(), tagName);
        }
        if (deleteTags || !github.isSkipTag()) {
            this.context.getLogger().debug("tagging local repository with {}", new Object[]{tagName});
            GitSdk.of((JReleaserContext)this.context).tag(tagName, true);
        }
        GHRelease release = api.createRelease(github.getCanonicalRepoName(), tagName).commitish(github.getTargetCommitish()).name(github.getEffectiveReleaseName()).draft(github.isDraft()).prerelease(github.isPrerelease()).body(changelog).create();
        api.uploadAssets(release, this.assets);
        if (github.getMilestone().isClose().booleanValue() && !this.context.getModel().getProject().isSnapshot() && (milestone = api.findMilestoneByName(github.getOwner(), github.getName(), github.getMilestone().getEffectiveName())).isPresent()) {
            api.closeMilestone(github.getOwner(), github.getName(), milestone.get());
        }
    }

    private void deleteTags(Github api, String repo, String tagName) {
        try {
            api.deleteTag(repo, tagName);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

