/*
 * Decompiled with CFR 0.152.
 */
package org.lowcoder.plugin.api.event;

import java.util.Map;

public interface LowcoderEvent {
    default public String getIpAddress() {
        return null;
    }

    default public String getSessionHash() {
        return null;
    }

    default public Boolean getIsAnonymous() {
        return null;
    }

    default public String getOrgId() {
        return null;
    }

    default public String getUserId() {
        return null;
    }

    public Map<String, Object> details();

    default public void detail(String name, String value) {
        this.details().put(name, value);
    }

    public EventType getEventType();

    public static enum Action {
        NONE,
        STARTUP,
        SHUTDOWN,
        LOGIN,
        LOGOUT,
        CREATE,
        READ,
        UPDATE,
        DELETE,
        PUBLISH,
        VIEW,
        EXECUTE,
        MOVE,
        RECYCLE,
        RESTORE,
        ADD,
        REMOVE,
        LEAVE,
        GRANT,
        REVOKE;

    }

    public static enum Type {
        NONE,
        SYSTEM,
        USER,
        APPLICATION,
        FOLDER,
        QUERY,
        GROUP,
        MEMBER,
        ROLE,
        PERMISSION,
        LIBRARY_QUERY,
        DATASOURCE,
        API_CALL;

    }

    public static enum EventType {
        USER_LOGIN(Type.USER, Action.LOGIN),
        USER_LOGOUT(Type.USER, Action.LOGOUT),
        APPLICATION_VIEW(Type.APPLICATION, Action.VIEW),
        APPLICATION_CREATE(Type.APPLICATION, Action.CREATE),
        APPLICATION_DELETE(Type.APPLICATION, Action.DELETE),
        APPLICATION_UPDATE(Type.APPLICATION, Action.UPDATE),
        APPLICATION_MOVE(Type.APPLICATION, Action.MOVE),
        APPLICATION_RECYCLED(Type.APPLICATION, Action.RECYCLE),
        APPLICATION_RESTORE(Type.APPLICATION, Action.RESTORE),
        FOLDER_CREATE(Type.FOLDER, Action.CREATE),
        FOLDER_DELETE(Type.FOLDER, Action.DELETE),
        FOLDER_UPDATE(Type.FOLDER, Action.UPDATE),
        QUERY_EXECUTION(Type.QUERY, Action.EXECUTE),
        GROUP_CREATE(Type.GROUP, Action.CREATE),
        GROUP_UPDATE(Type.GROUP, Action.UPDATE),
        GROUP_DELETE(Type.GROUP, Action.DELETE),
        GROUP_MEMBER_ADD(Type.GROUP, Type.MEMBER, Action.ADD),
        GROUP_MEMBER_ROLE_UPDATE(Type.GROUP, Type.MEMBER, Type.ROLE, Action.UPDATE),
        GROUP_MEMBER_LEAVE(Type.GROUP, Type.MEMBER, Action.LEAVE),
        GROUP_MEMBER_REMOVE(Type.GROUP, Type.MEMBER, Action.REMOVE),
        SERVER_START_UP(Type.SYSTEM, Action.STARTUP),
        SERVER_INFO(Type.SYSTEM, Action.VIEW),
        DATA_SOURCE_CREATE(Type.DATASOURCE, Action.CREATE),
        DATA_SOURCE_UPDATE(Type.DATASOURCE, Action.UPDATE),
        DATA_SOURCE_DELETE(Type.DATASOURCE, Action.DELETE),
        DATA_SOURCE_PERMISSION_GRANT(Type.DATASOURCE, Type.PERMISSION, Action.GRANT),
        DATA_SOURCE_PERMISSION_UPDATE(Type.DATASOURCE, Type.PERMISSION, Action.UPDATE),
        DATA_SOURCE_PERMISSION_DELETE(Type.DATASOURCE, Type.PERMISSION, Action.DELETE),
        LIBRARY_QUERY_CREATE(Type.LIBRARY_QUERY, Action.CREATE),
        LIBRARY_QUERY_UPDATE(Type.LIBRARY_QUERY, Action.UPDATE),
        LIBRARY_QUERY_DELETE(Type.LIBRARY_QUERY, Action.DELETE),
        LIBRARY_QUERY_PUBLISH(Type.LIBRARY_QUERY, Action.PUBLISH),
        API_CALL_EVENT(Type.API_CALL, Action.NONE);

        private Type type;
        private Type subType;
        private Type subSubType;
        private Action action;

        private EventType(Type type, Action action) {
            this(type, Type.NONE, action);
        }

        private EventType(Type type, Type subType, Action action) {
            this(type, subType, Type.NONE, action);
        }

        private EventType(Type type, Type subType, Type subSubType, Action action) {
            this.type = type;
            this.subType = subType;
            this.subSubType = subSubType;
            this.action = action;
        }

        public Type getType() {
            return this.type;
        }

        public Type getSubType() {
            return this.subType;
        }

        public Type getSubSubType() {
            return this.subSubType;
        }

        public Action getAction() {
            return this.action;
        }
    }
}

