/*
 * Decompiled with CFR 0.152.
 */
package org.lowcoder.plugin.api.data;

import java.net.URI;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.lowcoder.plugin.api.PluginEndpoint;

public interface EndpointRequest {
    public URI uri();

    public PluginEndpoint.Method method();

    public CompletableFuture<byte[]> body();

    public Map<String, List<String>> headers();

    default public List<String> header(String header) {
        return this.headers().getOrDefault(header, null);
    }

    public Map<String, List<Map.Entry<String, String>>> cookies();

    default public List<Map.Entry<String, String>> cookie(String cookie) {
        return this.cookies().getOrDefault(cookie, null);
    }

    public Map<String, Object> attributes();

    default public Optional<Object> attribute(String name) {
        return Optional.ofNullable(this.attributes().get(name));
    }

    public Map<String, String> pathVariables();

    default public String pathVariable(String name) {
        Map<String, String> pathVariables = this.pathVariables();
        if (pathVariables.containsKey(name)) {
            return this.pathVariables().get(name);
        }
        throw new IllegalArgumentException("No path variable with name \"" + name + "\" available");
    }

    public Map<String, List<String>> queryParams();

    default public List<String> queryParam(String name) {
        Map<String, List<String>> queryParams = this.queryParams();
        if (queryParams.containsKey(name)) {
            return this.queryParams().get(name);
        }
        throw new IllegalArgumentException("No query param with name \"" + name + "\" available");
    }

    public CompletableFuture<? extends Principal> principal();
}

