/*
 *  Copyright 2023 Red Hat
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.patternfly.chart;

public enum ChartType {

    Bullet("blt", "PF6/Chart/Bullet"),

    Donut("dnt", "PF6/Chart/Donut"),

    DonutUtilization("dntu", "PF6/Chart/DonutUtilization"),

    DonutThreshold("dntt", "PF6/Chart/DonutThreshold"),
    ;

    public final String id;
    public final String chartName;

    ChartType(String id, String chartName) {
        this.id = id;
        this.chartName = chartName;
    }
}
