/*
 * Decompiled with CFR 0.152.
 */
package org.pidster.java.lang.instrument;

import java.io.File;
import java.lang.instrument.Instrumentation;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pidster.java.lang.instrument.AgentBootstrap;
import org.pidster.java.lang.instrument.AgentInstallationException;
import org.pidster.java.lang.instrument.TargetClassInstantiationException;

public class Agent {
    private static final String AGENT_PARAM_LIBS = "libs";
    private static final String AGENT_PARAM_THREAD = "thread";
    private static final Logger LOG = Logger.getLogger(Agent.class.getName());
    private final String agentArgs;
    private final Instrumentation instrumentation;
    private final boolean preStarted;

    public static void premain(String agentArgs, Instrumentation instrumentation) {
        Agent.internal(agentArgs, instrumentation, false);
    }

    public static void agentmain(String agentArgs, Instrumentation instrumentation) {
        Agent.internal(agentArgs, instrumentation, true);
    }

    private static void internal(String agentArgs, Instrumentation instrumentation, boolean preStarted) {
        Agent agent = new Agent(agentArgs, instrumentation, preStarted);
        agent.load();
    }

    public Agent(String agentArgs, Instrumentation instrumentation, boolean preStarted) {
        this.agentArgs = agentArgs;
        this.instrumentation = instrumentation;
        this.preStarted = preStarted;
    }

    private void load() {
        String[] pairs;
        HashMap<String, String> args = new HashMap<String, String>();
        LOG.log(Level.FINE, "Parsing agentArgs:" + this.agentArgs);
        for (String pair : pairs = this.agentArgs.split("\\,")) {
            String[] nameValue = pair.split("=");
            LOG.log(Level.FINE, "Adding param:" + nameValue);
            args.put(nameValue[0], nameValue[1]);
        }
        try {
            String runnableClass = (String)args.get(AGENT_PARAM_THREAD);
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            Thread t = this.instantiateThreadClass(args, runnableClass, tccl);
            Thread.currentThread().setContextClassLoader(tccl);
            if (t instanceof AgentBootstrap) {
                AgentBootstrap ab = (AgentBootstrap)((Object)t);
                ab.setInstrumentation(this.instrumentation);
                ab.setPreStarted(this.preStarted);
                ab.start();
            } else {
                t.setName("agent-bootstrap");
                t.start();
            }
            System.out.printf("Injected class %s via javaagent %s with arguments %s %n", runnableClass, Agent.class.getName(), this.agentArgs);
        }
        catch (Exception e) {
            throw new AgentInstallationException(e);
        }
    }

    private Thread instantiateThreadClass(Map<String, String> args, String threadClass, ClassLoader tccl) throws TargetClassInstantiationException {
        try {
            Thread t;
            URL[] urls = this.getClassLoaderURLs(args);
            URLClassLoader cl = new URLClassLoader(urls, tccl);
            Thread.currentThread().setContextClassLoader(cl);
            Class<?> c = cl.loadClass(threadClass);
            if (Thread.class.isAssignableFrom(c)) {
                Class<Thread> tc = c.asSubclass(Thread.class);
                t = tc.newInstance();
            } else if (Runnable.class.isAssignableFrom(c)) {
                Class<Runnable> rc = c.asSubclass(Runnable.class);
                Runnable r = rc.newInstance();
                t = new Thread(r);
            } else {
                throw new TargetClassInstantiationException("Not a runnable or Thread");
            }
            t.setDaemon(true);
            t.setContextClassLoader(cl);
            return t;
        }
        catch (ClassNotFoundException e) {
            throw new TargetClassInstantiationException(e);
        }
        catch (InstantiationException e) {
            throw new TargetClassInstantiationException(e);
        }
        catch (IllegalAccessException e) {
            throw new TargetClassInstantiationException(e);
        }
    }

    private URL[] getClassLoaderURLs(Map<String, String> args) {
        HashSet<URL> urlSet = new HashSet<URL>();
        if (args.containsKey(AGENT_PARAM_LIBS)) {
            File[] files;
            String libs = args.get(AGENT_PARAM_LIBS);
            File libdir = new File(libs);
            LOG.log(Level.FINE, "Searching: " + libdir.getAbsolutePath());
            for (File file : files = libdir.listFiles()) {
                try {
                    LOG.log(Level.FINE, "Adding: " + file.getAbsolutePath());
                    URL url = file.toURI().toURL();
                    urlSet.add(url);
                }
                catch (MalformedURLException e) {
                    LOG.log(Level.SEVERE, "Unable to parse: " + file.getAbsolutePath(), e);
                }
            }
        }
        URL[] urls = new URL[urlSet.size()];
        return urlSet.toArray(urls);
    }
}

