/*
 * Decompiled with CFR 0.152.
 */
package org.pidster.java.lang.instrument;

import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pidster.java.lang.instrument.AgentInstallationException;
import org.pidster.java.util.reflection.Reflector;
import org.pidster.java.util.reflection.ReflectorException;

public class Attacher {
    private static final String COM_SUN_TOOLS_ATTACH_VIRTUAL_MACHINE = "com.sun.tools.attach.VirtualMachine";
    private static final Logger LOG = Logger.getLogger(Attacher.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args == null || args.length != 2) {
            Attacher.usage();
            return;
        }
        String pid = args[0];
        String javaAgentProps = args[1];
        if (!args[1].startsWith("-javaagent=")) {
            LOG.log(Level.SEVERE, "Parameter formatting error: " + javaAgentProps);
            Attacher.usage();
            return;
        }
        String agent = javaAgentProps.replaceFirst("-javaagent=", "");
        LOG.log(Level.INFO, "user.dir: " + System.getProperty("user.dir"));
        LOG.log(Level.INFO, "PID: " + pid);
        LOG.log(Level.INFO, "Agent+props: " + javaAgentProps);
        Object machine = null;
        try {
            machine = Reflector.invokeStatic(COM_SUN_TOOLS_ATTACH_VIRTUAL_MACHINE, "attach", pid);
            int index = agent.indexOf(".jar=");
            if (index > -1) {
                String iagent = agent.substring(0, index + 4);
                String props = agent.substring(index + 5);
                agent = Attacher.normalize(iagent);
                LOG.log(Level.INFO, "Agent: " + agent);
                LOG.log(Level.INFO, "Props: " + props);
                Attacher.validate(props);
                Reflector.invoke(machine, "loadAgent", agent, props);
            } else {
                agent = Attacher.normalize(agent);
                Reflector.invoke(machine, "loadAgent", agent);
            }
            Properties systemProperties = (Properties)Reflector.invoke(machine, "getSystemProperties", new Object[0]);
            systemProperties.setProperty("agent.user.dir", System.getProperty("user.dir"));
        }
        catch (ReflectorException e) {
            LOG.log(Level.SEVERE, "Unable to load agent: " + agent, e);
        }
        finally {
            if (machine != null) {
                try {
                    Reflector.invoke(machine, "detach", new Object[0]);
                }
                catch (ReflectorException e) {
                    LOG.log(Level.WARNING, "Exception when detaching from VirtualMachine", e);
                }
            }
        }
    }

    private static void validate(String props) {
    }

    private static String normalize(String path) {
        File f = new File(path);
        if (!f.exists()) {
            throw new AgentInstallationException("Supplied path does not exist: " + path);
        }
        return f.getAbsolutePath();
    }

    private static void usage() {
        System.out.println("Usage: inject <pid> -javaagent:<jarpath>[=options]");
    }
}

