/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.basic;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.revapi.AnalysisContext;
import org.revapi.ArchiveAnalyzer;
import org.revapi.Element;
import org.revapi.ElementMatcher;
import org.revapi.FilterFinishResult;
import org.revapi.FilterMatch;
import org.revapi.FilterStartResult;
import org.revapi.TreeFilter;
import org.revapi.TreeFilterProvider;
import org.revapi.basic.RegexElementMatcher;

public class ConfigurableElementFilter
implements TreeFilterProvider {
    private final List<ElementMatcher.CompiledRecipe> elementIncludeRecipes = new ArrayList<ElementMatcher.CompiledRecipe>();
    private final List<ElementMatcher.CompiledRecipe> elementExcludeRecipes = new ArrayList<ElementMatcher.CompiledRecipe>();
    private final List<Pattern> archiveIncludes = new ArrayList<Pattern>();
    private final List<Pattern> archiveExcludes = new ArrayList<Pattern>();
    private boolean doNothing;
    private boolean includeByDefault;

    @Nullable
    public String getExtensionId() {
        return "revapi.filter";
    }

    @Nullable
    public Reader getJSONSchema() {
        return new InputStreamReader(this.getClass().getResourceAsStream("/META-INF/filter-schema.json"), StandardCharsets.UTF_8);
    }

    public void initialize(@Nonnull AnalysisContext analysisContext) {
        JsonNode archives;
        JsonNode root = analysisContext.getConfigurationNode();
        if (root.isNull()) {
            this.doNothing = true;
            return;
        }
        JsonNode elements = root.path("elements");
        if (!elements.isMissingNode()) {
            ConfigurableElementFilter.readComplexFilter(elements, analysisContext.getMatchers(), this.elementIncludeRecipes, this.elementExcludeRecipes);
        }
        if (!(archives = root.path("archives")).isMissingNode()) {
            ConfigurableElementFilter.readSimpleFilter(archives, this.archiveIncludes, this.archiveExcludes);
        }
        this.includeByDefault = this.elementIncludeRecipes.isEmpty() && this.archiveIncludes.isEmpty();
        this.doNothing = this.includeByDefault && this.elementExcludeRecipes.isEmpty() && this.archiveExcludes.isEmpty();
    }

    public <E extends Element<E>> Optional<TreeFilter<E>> filterFor(ArchiveAnalyzer<E> archiveAnalyzer) {
        final List excludes = this.elementExcludeRecipes.stream().map(r -> r.filterFor(archiveAnalyzer)).collect(Collectors.toList());
        final List includes = this.elementIncludeRecipes.stream().map(r -> r.filterFor(archiveAnalyzer)).collect(Collectors.toList());
        return Optional.of(new TreeFilter<E>(){
            private final IdentityHashMap<E, IncludeExcludeResult> filterResults = new IdentityHashMap();

            public FilterStartResult start(E element) {
                String archive;
                if (ConfigurableElementFilter.this.doNothing) {
                    return FilterStartResult.matchAndDescendInherited();
                }
                String string = archive = element.getArchive() == null ? null : element.getArchive().getName();
                if (archive != null && !ConfigurableElementFilter.isIncluded(archive, ConfigurableElementFilter.this.archiveIncludes, ConfigurableElementFilter.this.archiveExcludes)) {
                    return FilterStartResult.doesntMatch();
                }
                Element parent = element.getParent();
                IncludeExcludeResult parentResults = parent == null ? null : this.filterResults.get(parent);
                FilterStartResult inclusion = ConfigurableElementFilter.includeFilterStart(includes, element);
                FilterStartResult exclusion = ConfigurableElementFilter.excludeFilterStart(excludes, element);
                IncludeExcludeResult res = new IncludeExcludeResult(inclusion, exclusion, parentResults);
                this.filterResults.put(element, res);
                return res.compute();
            }

            public FilterFinishResult finish(E element) {
                if (ConfigurableElementFilter.this.doNothing) {
                    return FilterFinishResult.matches();
                }
                IncludeExcludeResult currentResult = this.filterResults.get(element);
                if (currentResult == null) {
                    return FilterFinishResult.doesntMatch();
                }
                FilterFinishResult include = ConfigurableElementFilter.includeFilterEnd(includes, element);
                FilterFinishResult exclude = ConfigurableElementFilter.excludeFilterEnd(excludes, element);
                FilterStartResult filterStartResult = currentResult.include == null ? null : (currentResult.include = include == null ? null : currentResult.include.withMatch(include.getMatch()));
                currentResult.exclude = currentResult.exclude == null ? null : (exclude == null ? null : currentResult.exclude.withMatch(exclude.getMatch()));
                return FilterFinishResult.from((FilterStartResult)currentResult.compute());
            }

            public Map<E, FilterFinishResult> finish() {
                if (ConfigurableElementFilter.this.doNothing) {
                    return Collections.emptyMap();
                }
                HashMap finalIncludes = new HashMap();
                for (Object f : includes) {
                    finalIncludes.putAll(f.finish());
                }
                HashMap finalExcludes = new HashMap();
                for (TreeFilter f : excludes) {
                    finalExcludes.putAll(f.finish());
                }
                HashMap<Element, FilterFinishResult> ret = new HashMap<Element, FilterFinishResult>();
                for (Map.Entry e : this.filterResults.entrySet()) {
                    FilterFinishResult em;
                    IncludeExcludeResult r = e.getValue();
                    Element el = (Element)e.getKey();
                    if (r.compute().getMatch() != FilterMatch.UNDECIDED) continue;
                    FilterFinishResult im = (FilterFinishResult)finalIncludes.get(el);
                    if (im == null) {
                        im = FilterFinishResult.from((FilterStartResult)r.include);
                    }
                    em = (em = (FilterFinishResult)finalExcludes.get(el)) == null ? FilterFinishResult.from((FilterStartResult)r.exclude) : em.negateMatch();
                    ret.put(el, im.and(em));
                }
                this.filterResults.clear();
                return ret;
            }
        });
    }

    public void close() {
    }

    @Nullable
    private static <E extends Element<E>> FilterStartResult includeFilterStart(List<TreeFilter<E>> includes, E element) {
        return includes.stream().map(f -> f.start(element).withDescend(true)).reduce(FilterStartResult::or).orElse(null);
    }

    @Nullable
    private static <E extends Element<E>> FilterFinishResult includeFilterEnd(List<TreeFilter<E>> includes, E element) {
        return includes.stream().map(f -> f.finish(element)).reduce(FilterFinishResult::or).orElse(null);
    }

    @Nullable
    private static <E extends Element<E>> FilterStartResult excludeFilterStart(List<TreeFilter<E>> excludes, E element) {
        return excludes.stream().map(f -> f.start(element).withDescend(true)).reduce(FilterStartResult::or).orElse(null);
    }

    @Nullable
    private static <E extends Element<E>> FilterFinishResult excludeFilterEnd(List<TreeFilter<E>> excludes, E element) {
        return excludes.stream().map(f -> f.finish(element)).reduce(FilterFinishResult::or).orElse(null);
    }

    private static void readSimpleFilter(JsonNode root, List<Pattern> include, List<Pattern> exclude) {
        JsonNode excludeNode;
        JsonNode includeNode = root.path("include");
        if (includeNode.isArray()) {
            for (JsonNode inc : includeNode) {
                include.add(Pattern.compile(inc.asText()));
            }
        }
        if ((excludeNode = root.path("exclude")).isArray()) {
            for (JsonNode exc : excludeNode) {
                exclude.add(Pattern.compile(exc.asText()));
            }
        }
    }

    private static void readComplexFilter(JsonNode root, Map<String, ElementMatcher> availableMatchers, List<ElementMatcher.CompiledRecipe> include, List<ElementMatcher.CompiledRecipe> exclude) {
        JsonNode excludeNode;
        JsonNode includeNode = root.path("include");
        if (includeNode.isArray()) {
            for (JsonNode inc : includeNode) {
                ElementMatcher.CompiledRecipe filter = ConfigurableElementFilter.parse(inc, availableMatchers);
                include.add(filter);
            }
        }
        if ((excludeNode = root.path("exclude")).isArray()) {
            for (JsonNode exc : excludeNode) {
                ElementMatcher.CompiledRecipe filter = ConfigurableElementFilter.parse(exc, availableMatchers);
                exclude.add(filter);
            }
        }
    }

    @Nullable
    private static ElementMatcher.CompiledRecipe parse(JsonNode filterDefinition, Map<String, ElementMatcher> availableMatchers) {
        RegexElementMatcher matcher;
        String recipe;
        if (filterDefinition.isTextual()) {
            recipe = filterDefinition.asText();
            matcher = new RegexElementMatcher();
        } else {
            recipe = filterDefinition.path("match").asText();
            matcher = availableMatchers.get(filterDefinition.path("matcher").asText(null));
        }
        if (matcher == null) {
            throw new IllegalStateException("Element matcher with id '" + filterDefinition.path("matcher").asText(null) + "' was not found.");
        }
        return (ElementMatcher.CompiledRecipe)matcher.compile(recipe).orElseThrow(() -> new IllegalArgumentException("Failed to compile the match recipe."));
    }

    private static boolean isIncluded(String representation, List<Pattern> includePatterns, List<Pattern> excludePatterns) {
        boolean include = true;
        if (!includePatterns.isEmpty()) {
            include = false;
            for (Pattern p : includePatterns) {
                if (!p.matcher(representation).matches()) continue;
                include = true;
                break;
            }
        }
        if (include) {
            for (Pattern p : excludePatterns) {
                if (!p.matcher(representation).matches()) continue;
                include = false;
                break;
            }
        }
        return include;
    }

    private static final class IncludeExcludeResult {
        @Nullable
        FilterStartResult include;
        @Nullable
        FilterStartResult exclude;
        IncludeExcludeResult parent;

        public IncludeExcludeResult(FilterStartResult include, FilterStartResult exclude, IncludeExcludeResult parent) {
            this.include = include;
            this.exclude = exclude;
            this.parent = parent;
        }

        FilterStartResult compute() {
            if (this.parent == null) {
                if (this.include == null) {
                    if (this.exclude == null) {
                        return FilterStartResult.matchAndDescendInherited();
                    }
                    return this.exclude.negateMatch().withInherited(true);
                }
                if (this.exclude == null) {
                    return this.include;
                }
                return this.include.and(this.exclude.negateMatch());
            }
            FilterStartResult parentResult = this.parent.compute();
            if (this.include == null) {
                if (this.exclude == null) {
                    return parentResult;
                }
                return FilterStartResult.inherit((FilterStartResult)parentResult).and(this.exclude.negateMatch());
            }
            if (this.exclude == null) {
                return FilterStartResult.inherit((FilterStartResult)parentResult).or(this.include);
            }
            if (parentResult.getMatch().toBoolean(true)) {
                return FilterStartResult.inherit((FilterStartResult)parentResult).and(this.exclude.negateMatch());
            }
            return this.include.and(this.exclude.negateMatch());
        }
    }
}

