/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.basic;

import java.io.Reader;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.revapi.AnalysisContext;
import org.revapi.ArchiveAnalyzer;
import org.revapi.Element;
import org.revapi.ElementMatcher;
import org.revapi.FilterMatch;
import org.revapi.FilterStartResult;
import org.revapi.TreeFilter;
import org.revapi.base.IndependentTreeFilter;

public final class ExactElementMatcher
implements ElementMatcher {
    public Optional<ElementMatcher.CompiledRecipe> compile(final String recipe) {
        return Optional.of(new ElementMatcher.CompiledRecipe(){

            public <E extends Element<E>> TreeFilter<E> filterFor(ArchiveAnalyzer<E> archiveAnalyzer) {
                return new StringMatch(recipe);
            }
        });
    }

    public void close() throws Exception {
    }

    @Nullable
    public String getExtensionId() {
        return "exact";
    }

    @Nullable
    public Reader getJSONSchema() {
        return null;
    }

    public void initialize(@Nonnull AnalysisContext analysisContext) {
    }

    private static final class StringMatch<E extends Element<E>>
    extends IndependentTreeFilter<E> {
        final String match;

        private StringMatch(String match) {
            this.match = match;
        }

        protected FilterStartResult doStart(E element) {
            boolean m = this.match.equals(element.getFullHumanReadableString());
            return FilterStartResult.direct((FilterMatch)FilterMatch.fromBoolean((boolean)m), (boolean)m);
        }
    }
}

