/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.basic;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.revapi.Difference;
import org.revapi.DifferenceTransform;
import org.revapi.Element;
import org.revapi.FilterFinishResult;
import org.revapi.FilterMatch;
import org.revapi.FilterStartResult;
import org.revapi.TreeFilter;

public abstract class MatchingProgress<E extends Element<E>>
implements DifferenceTransform.TraversalTracker<E> {
    protected final boolean regex;
    protected final String code;
    protected final Pattern codeRegex;
    protected final TreeFilter<E> oldFilter;
    protected final TreeFilter<E> newFilter;
    protected final Map<String, String> attachments;
    protected final Map<String, Pattern> attachmentRegexes;
    protected final Map<E, Set<E>> decidedlyMatchingElementPairs = new HashMap<E, Set<E>>();
    protected final Map<E, Set<E>> undecidedElementPairs = new HashMap<E, Set<E>>();

    public MatchingProgress(boolean regex, String code, Pattern codeRegex, TreeFilter<E> oldFilter, TreeFilter<E> newFilter, Map<String, String> attachments, Map<String, Pattern> attachmentRegexes) {
        this.regex = regex;
        this.code = code;
        this.codeRegex = codeRegex;
        this.oldFilter = oldFilter;
        this.newFilter = newFilter;
        this.attachments = attachments;
        this.attachmentRegexes = attachmentRegexes;
    }

    public boolean startElements(@Nullable E oldElement, @Nullable E newElement) {
        FilterStartResult newRes;
        FilterStartResult oldRes;
        FilterStartResult filterStartResult = oldElement == null ? (this.oldFilter == null ? FilterStartResult.matchAndDescend() : FilterStartResult.doesntMatch()) : (oldRes = this.oldFilter == null ? FilterStartResult.matchAndDescend() : this.oldFilter.start(oldElement));
        FilterStartResult filterStartResult2 = newElement == null ? (this.newFilter == null ? FilterStartResult.matchAndDescend() : FilterStartResult.doesntMatch()) : (newRes = this.newFilter == null ? FilterStartResult.matchAndDescend() : this.newFilter.start(newElement));
        if (oldRes.getMatch().toBoolean(false) && newRes.getMatch().toBoolean(false)) {
            this.decidedlyMatchingElementPairs.computeIfAbsent(oldElement, __ -> new HashSet()).add(newElement);
        } else if (oldRes.getMatch() == FilterMatch.UNDECIDED || newRes.getMatch() == FilterMatch.UNDECIDED) {
            this.undecidedElementPairs.computeIfAbsent(oldElement, __ -> new HashSet()).add(newElement);
        }
        return true;
    }

    public void endElements(@Nullable E oldElement, @Nullable E newElement) {
        FilterMatch newMatch;
        FilterMatch oldMatch;
        FilterMatch filterMatch = oldElement == null ? (this.oldFilter == null ? FilterMatch.MATCHES : FilterMatch.DOESNT_MATCH) : (oldMatch = this.oldFilter == null ? FilterMatch.MATCHES : this.oldFilter.finish(oldElement).getMatch());
        FilterMatch filterMatch2 = newElement == null ? (this.newFilter == null ? FilterMatch.MATCHES : FilterMatch.DOESNT_MATCH) : (newMatch = this.newFilter == null ? FilterMatch.MATCHES : this.newFilter.finish(newElement).getMatch());
        if (oldMatch.toBoolean(false) && newMatch.toBoolean(false)) {
            this.decidedlyMatchingElementPairs.computeIfAbsent(oldElement, __ -> new HashSet()).add(newElement);
            Set<E> undecidedNews = this.undecidedElementPairs.get(oldElement);
            if (undecidedNews != null) {
                undecidedNews.remove(newElement);
            }
        }
    }

    public void endTraversal() {
        HashMap<Element, Set> decided = new HashMap<Element, Set>();
        if (this.oldFilter != null) {
            for (Map.Entry e : this.oldFilter.finish().entrySet()) {
                if (!((FilterFinishResult)e.getValue()).getMatch().toBoolean(false)) continue;
                for (Map.Entry<Object, Set<Object>> entry : this.undecidedElementPairs.entrySet()) {
                    Element oldEl = (Element)entry.getKey();
                    if (oldEl != null && !oldEl.equals(e.getKey())) continue;
                    decided.computeIfAbsent(oldEl, __ -> new HashSet()).addAll((Collection)entry.getValue());
                }
            }
        }
        if (this.newFilter != null) {
            for (Map.Entry e : this.newFilter.finish().entrySet()) {
                if (((FilterFinishResult)e.getValue()).getMatch().toBoolean(false)) continue;
                for (Set set : decided.values()) {
                    set.remove(e.getKey());
                }
            }
        }
        decided.forEach((o, ns) -> this.decidedlyMatchingElementPairs.computeIfAbsent(o, __ -> new HashSet()).addAll(ns));
    }

    public boolean matches(Difference difference, Element<?> oldElement, Element<?> newElement) {
        boolean elementsMatch;
        boolean codeMatch;
        boolean bl = codeMatch = this.regex ? this.codeRegex.matcher(difference.code).matches() : this.code.equals(difference.code);
        if (!codeMatch) {
            return false;
        }
        Set<E> news = this.decidedlyMatchingElementPairs.get(oldElement);
        boolean bl2 = elementsMatch = news != null && news.contains(newElement);
        while (!elementsMatch) {
            oldElement = oldElement == null ? null : oldElement.getParent();
            Element element = newElement = newElement == null ? null : newElement.getParent();
            if (oldElement == null && newElement == null) break;
            news = this.decidedlyMatchingElementPairs.get(oldElement);
            elementsMatch = news != null && news.contains(newElement);
        }
        if (!elementsMatch) {
            return false;
        }
        if (this.regex) {
            boolean allMatched = this.attachmentRegexes.isEmpty() || !difference.attachments.isEmpty();
            for (Map.Entry e : difference.attachments.entrySet()) {
                String key = (String)e.getKey();
                String val = (String)e.getValue();
                Pattern match = this.attachmentRegexes.get(key);
                if (match != null && !match.matcher(val).matches()) {
                    return false;
                }
                allMatched = true;
            }
            return allMatched;
        }
        boolean allMatched = this.attachments.isEmpty() || !difference.attachments.isEmpty();
        for (Map.Entry e : difference.attachments.entrySet()) {
            String key = (String)e.getKey();
            String val = (String)e.getValue();
            String match = this.attachments.get(key);
            if (match != null && !match.equals(val)) {
                return false;
            }
            allMatched = true;
        }
        return allMatched;
    }

    @Nullable
    public abstract Difference transformMatching(Difference var1, Element<?> var2, Element<?> var3);
}

