/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.basic;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.revapi.AnalysisContext;
import org.revapi.Archive;
import org.revapi.ArchiveAnalyzer;
import org.revapi.Element;
import org.revapi.ElementMatcher;
import org.revapi.FilterFinishResult;
import org.revapi.FilterStartResult;
import org.revapi.TreeFilter;
import org.revapi.TreeFilterProvider;
import org.revapi.base.OverridableIncludeExcludeTreeFilter;
import org.revapi.basic.RegexElementMatcher;

public class ConfigurableElementFilter
implements TreeFilterProvider {
    private final List<ElementMatcher.CompiledRecipe> elementIncludeRecipes = new ArrayList<ElementMatcher.CompiledRecipe>();
    private final List<ElementMatcher.CompiledRecipe> elementExcludeRecipes = new ArrayList<ElementMatcher.CompiledRecipe>();
    private final List<Pattern> archiveIncludes = new ArrayList<Pattern>();
    private final List<Pattern> archiveExcludes = new ArrayList<Pattern>();
    private boolean doNothing;

    @Nullable
    public String getExtensionId() {
        return "revapi.filter";
    }

    @Nullable
    public Reader getJSONSchema() {
        return new InputStreamReader(this.getClass().getResourceAsStream("/META-INF/filter-schema.json"), StandardCharsets.UTF_8);
    }

    public void initialize(@Nonnull AnalysisContext analysisContext) {
        JsonNode archives;
        JsonNode root = analysisContext.getConfigurationNode();
        if (root.isNull()) {
            this.doNothing = true;
            return;
        }
        JsonNode elements = root.path("elements");
        if (!elements.isMissingNode()) {
            ConfigurableElementFilter.readComplexFilter(elements, analysisContext.getMatchers(), this.elementIncludeRecipes, this.elementExcludeRecipes);
        }
        if (!(archives = root.path("archives")).isMissingNode()) {
            ConfigurableElementFilter.readSimpleFilter(archives, this.archiveIncludes, this.archiveExcludes);
        }
        this.doNothing = this.elementIncludeRecipes.isEmpty() && this.archiveIncludes.isEmpty() && this.elementExcludeRecipes.isEmpty() && this.archiveExcludes.isEmpty();
    }

    public <E extends Element<E>> Optional<TreeFilter<E>> filterFor(ArchiveAnalyzer<E> archiveAnalyzer) {
        TreeFilter excludes = this.elementExcludeRecipes.isEmpty() ? null : TreeFilter.union(this.elementExcludeRecipes.stream().map(r -> r.filterFor(archiveAnalyzer)).filter(Objects::nonNull).collect(Collectors.toList()));
        TreeFilter includes = this.elementIncludeRecipes.isEmpty() ? null : TreeFilter.union(this.elementIncludeRecipes.stream().map(r -> r.filterFor(archiveAnalyzer)).filter(Objects::nonNull).collect(Collectors.toList()));
        return Optional.of(new OverridableIncludeExcludeTreeFilter<E>(includes, excludes){
            final Set<Archive> excludedArchives;
            {
                this.excludedArchives = Collections.newSetFromMap(new IdentityHashMap());
            }

            public FilterStartResult start(E element) {
                String archive;
                if (ConfigurableElementFilter.this.doNothing) {
                    return FilterStartResult.defaultResult();
                }
                String string = archive = element.getArchive() == null ? null : element.getArchive().getName();
                if (archive != null && !ConfigurableElementFilter.isIncluded(archive, ConfigurableElementFilter.this.archiveIncludes, ConfigurableElementFilter.this.archiveExcludes)) {
                    this.excludedArchives.add(element.getArchive());
                    return FilterStartResult.doesntMatch();
                }
                return super.start(element);
            }

            public FilterFinishResult finish(E element) {
                if (ConfigurableElementFilter.this.doNothing) {
                    return FilterFinishResult.matches();
                }
                if (this.excludedArchives.contains(element.getArchive())) {
                    return FilterFinishResult.doesntMatch();
                }
                return super.finish(element);
            }

            public Map<E, FilterFinishResult> finish() {
                if (ConfigurableElementFilter.this.doNothing) {
                    return Collections.emptyMap();
                }
                this.excludedArchives.clear();
                return super.finish();
            }
        });
    }

    public void close() {
    }

    private static void readSimpleFilter(JsonNode root, List<Pattern> include, List<Pattern> exclude) {
        JsonNode excludeNode;
        JsonNode includeNode = root.path("include");
        if (includeNode.isArray()) {
            for (JsonNode inc : includeNode) {
                include.add(Pattern.compile(inc.asText()));
            }
        }
        if ((excludeNode = root.path("exclude")).isArray()) {
            for (JsonNode exc : excludeNode) {
                exclude.add(Pattern.compile(exc.asText()));
            }
        }
    }

    private static void readComplexFilter(JsonNode root, Map<String, ElementMatcher> availableMatchers, List<ElementMatcher.CompiledRecipe> include, List<ElementMatcher.CompiledRecipe> exclude) {
        JsonNode excludeNode;
        JsonNode includeNode = root.path("include");
        if (includeNode.isArray()) {
            for (JsonNode inc : includeNode) {
                ElementMatcher.CompiledRecipe filter = ConfigurableElementFilter.parse(inc, availableMatchers);
                include.add(filter);
            }
        }
        if ((excludeNode = root.path("exclude")).isArray()) {
            for (JsonNode exc : excludeNode) {
                ElementMatcher.CompiledRecipe filter = ConfigurableElementFilter.parse(exc, availableMatchers);
                exclude.add(filter);
            }
        }
    }

    @Nullable
    private static ElementMatcher.CompiledRecipe parse(JsonNode filterDefinition, Map<String, ElementMatcher> availableMatchers) {
        RegexElementMatcher matcher;
        String recipe;
        if (filterDefinition.isTextual()) {
            recipe = filterDefinition.asText();
            matcher = new RegexElementMatcher();
        } else {
            recipe = filterDefinition.path("match").asText();
            matcher = availableMatchers.get(filterDefinition.path("matcher").asText(null));
        }
        if (matcher == null) {
            throw new IllegalStateException("Element matcher with id '" + filterDefinition.path("matcher").asText(null) + "' was not found.");
        }
        return (ElementMatcher.CompiledRecipe)matcher.compile(recipe).orElseThrow(() -> new IllegalArgumentException("Failed to compile the match recipe."));
    }

    private static boolean isIncluded(String representation, List<Pattern> includePatterns, List<Pattern> excludePatterns) {
        boolean include = true;
        if (!includePatterns.isEmpty()) {
            include = false;
            for (Pattern p : includePatterns) {
                if (!p.matcher(representation).matches()) continue;
                include = true;
                break;
            }
        }
        if (include) {
            for (Pattern p : excludePatterns) {
                if (!p.matcher(representation).matches()) continue;
                include = false;
                break;
            }
        }
        return include;
    }
}

