/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.basic;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.revapi.ArchiveAnalyzer;
import org.revapi.Element;
import org.revapi.ElementMatcher;
import org.revapi.TreeFilter;
import org.revapi.basic.ExactElementMatcher;
import org.revapi.basic.MatchingProgress;
import org.revapi.basic.RegexElementMatcher;
import org.revapi.configuration.JSONUtil;

public abstract class DifferenceMatchRecipe {
    final JsonNode config;
    final boolean regex;
    final String code;
    final Pattern codeRegex;
    final ElementMatcher.CompiledRecipe oldRecipe;
    final ElementMatcher.CompiledRecipe newRecipe;
    final Map<String, String> attachments;
    final Map<String, Pattern> attachmentRegexes;

    protected DifferenceMatchRecipe(Map<String, ElementMatcher> matchers, JsonNode config, String ... additionalReservedProperties) {
        if (!config.hasNonNull("code")) {
            throw new IllegalArgumentException("Difference code has to be specified.");
        }
        HashSet<String> reservedProperties = new HashSet<String>(4 + additionalReservedProperties.length);
        reservedProperties.add("regex");
        reservedProperties.add("code");
        reservedProperties.add("old");
        reservedProperties.add("new");
        reservedProperties.addAll(Arrays.asList(additionalReservedProperties));
        this.regex = config.path("regex").asBoolean();
        this.code = config.get("code").asText();
        this.codeRegex = this.regex ? Pattern.compile(this.code) : null;
        this.oldRecipe = DifferenceMatchRecipe.getRecipe(this.regex, config.path("old"), matchers);
        this.newRecipe = DifferenceMatchRecipe.getRecipe(this.regex, config.path("new"), matchers);
        this.attachments = DifferenceMatchRecipe.getAttachments(config, reservedProperties);
        this.attachmentRegexes = this.regex ? this.attachments.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Pattern.compile((String)e.getValue()))) : null;
        this.config = config;
    }

    @Nullable
    public <E extends Element<E>> MatchingProgress<E> startWithAnalyzers(ArchiveAnalyzer<E> oldAnalyzer, ArchiveAnalyzer<E> newAnalyzer) {
        TreeFilter oldFilter = this.oldRecipe == null ? null : this.oldRecipe.filterFor(oldAnalyzer);
        TreeFilter newFilter = this.newRecipe == null ? null : this.newRecipe.filterFor(newAnalyzer);
        return this.createMatchingProgress(oldFilter, newFilter);
    }

    protected abstract <E extends Element<E>> MatchingProgress<E> createMatchingProgress(@Nullable TreeFilter<E> var1, @Nullable TreeFilter<E> var2);

    private static ElementMatcher.CompiledRecipe getRecipe(boolean regex, JsonNode elementRoot, Map<String, ElementMatcher> matchers) {
        if (elementRoot.isMissingNode()) {
            return null;
        }
        if (elementRoot.isTextual()) {
            String recipe = elementRoot.asText();
            return (ElementMatcher.CompiledRecipe)(regex ? new RegexElementMatcher() : new ExactElementMatcher()).compile(recipe).orElseThrow(() -> new IllegalArgumentException("Failed to compile the match recipe."));
        }
        String matcherId = elementRoot.path("matcher").asText();
        String recipe = elementRoot.path("match").asText();
        ElementMatcher matcher = matchers.get(matcherId);
        if (matcher == null) {
            throw new IllegalArgumentException("Matcher called '" + matcherId + "' not found.");
        }
        return (ElementMatcher.CompiledRecipe)matcher.compile(recipe).orElseThrow(() -> new IllegalArgumentException("Failed to compile the match recipe."));
    }

    private static Map<String, String> getAttachments(JsonNode elementRoot, Set<String> reservedProperties) {
        if (JSONUtil.isNullOrUndefined((JsonNode)elementRoot)) {
            return Collections.emptyMap();
        }
        if (!elementRoot.isObject()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        Iterator it = elementRoot.fields();
        while (it.hasNext()) {
            Map.Entry e = (Map.Entry)it.next();
            if (reservedProperties.contains(e.getKey())) continue;
            ret.put((String)e.getKey(), ((JsonNode)e.getValue()).asText());
        }
        return ret;
    }
}

