/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.basic;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.revapi.AnalysisContext;
import org.revapi.Archive;
import org.revapi.CompatibilityType;
import org.revapi.Difference;
import org.revapi.DifferenceSeverity;
import org.revapi.DifferenceTransform;
import org.revapi.Element;
import org.revapi.TransformationResult;
import org.revapi.basic.SemverVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SemverIgnoreTransform<E extends Element<E>>
implements DifferenceTransform<E> {
    private static final Logger LOG = LoggerFactory.getLogger(SemverIgnoreTransform.class);
    private boolean enabled;
    private DifferenceSeverity allowedSeverity;
    private List<String> passThroughDifferences;

    @Nonnull
    public Pattern[] getDifferenceCodePatterns() {
        Pattern[] patternArray;
        if (this.enabled) {
            Pattern[] patternArray2 = new Pattern[1];
            patternArray = patternArray2;
            patternArray2[0] = Pattern.compile(".*");
        } else {
            patternArray = new Pattern[]{};
        }
        return patternArray;
    }

    public TransformationResult tryTransform(@Nullable E oldElement, @Nullable E newElement, Difference difference) {
        if (!this.enabled) {
            return TransformationResult.keep();
        }
        if (this.passThroughDifferences.contains(difference.code)) {
            return TransformationResult.keep();
        }
        if (this.allowedSeverity == null) {
            return TransformationResult.replaceWith((Difference)this.asBreaking(difference));
        }
        if (this.allowedSeverity == DifferenceSeverity.BREAKING) {
            return TransformationResult.discard();
        }
        DifferenceSeverity diffSeverity = this.getMaxSeverity(difference);
        if (this.allowedSeverity.ordinal() - diffSeverity.ordinal() >= 0) {
            return TransformationResult.discard();
        }
        return TransformationResult.replaceWith((Difference)this.asBreaking(difference));
    }

    private Difference asBreaking(Difference d) {
        Difference.Builder bld = (Difference.Builder)((Difference.Builder)Difference.copy((Difference)d).addClassification(CompatibilityType.OTHER, DifferenceSeverity.BREAKING)).addAttachment("breaksSemanticVersioning", "true");
        if (d.description == null || !d.description.endsWith("(breaks semantic versioning)")) {
            bld.withDescription(d.description == null ? "(breaks semantic versioning)" : d.description + " (breaks semantic versioning)");
        }
        if (!d.name.startsWith("Incompatible with the current version: ")) {
            bld.withName("Incompatible with the current version: " + d.name);
        }
        return bld.build();
    }

    private DifferenceSeverity getMaxSeverity(Difference diff) {
        return (DifferenceSeverity)diff.classification.values().stream().max((d1, d2) -> d1.ordinal() - d2.ordinal()).get();
    }

    public void close() throws Exception {
    }

    @Nullable
    public String getExtensionId() {
        return "revapi.semver.ignore";
    }

    @Nullable
    public Reader getJSONSchema() {
        return new InputStreamReader(this.getClass().getResourceAsStream("/META-INF/semver-ignore-schema.json"), StandardCharsets.UTF_8);
    }

    public void initialize(@Nonnull AnalysisContext analysisContext) {
        JsonNode node = analysisContext.getConfigurationNode();
        this.enabled = node.path("enabled").asBoolean(false);
        if (this.enabled) {
            if (this.hasMultipleElements(analysisContext.getOldApi().getArchives()) || this.hasMultipleElements(analysisContext.getNewApi().getArchives())) {
                throw new IllegalArgumentException("The semver extension doesn't handle changes in multiple archives at once.");
            }
            Iterator oldArchives = analysisContext.getOldApi().getArchives().iterator();
            Iterator newArchives = analysisContext.getNewApi().getArchives().iterator();
            if (!oldArchives.hasNext() || !newArchives.hasNext()) {
                this.enabled = false;
                return;
            }
            Archive oldArchive = (Archive)oldArchives.next();
            Archive newArchive = (Archive)newArchives.next();
            if (!(oldArchive instanceof Archive.Versioned)) {
                throw new IllegalArgumentException("Old archive doesn't support extracting the version.");
            }
            if (!(newArchive instanceof Archive.Versioned)) {
                throw new IllegalArgumentException("New archive doesn't support extracting the version.");
            }
            String oldVersionString = ((Archive.Versioned)oldArchive).getVersion();
            String newVersionString = ((Archive.Versioned)newArchive).getVersion();
            SemverVersion oldVersion = SemverVersion.parse(oldVersionString, true);
            SemverVersion newVersion = SemverVersion.parse(newVersionString, true);
            if (newVersion.major == 0 && oldVersion.major == 0 && !node.hasNonNull("versionIncreaseAllows")) {
                DifferenceSeverity minorChangeAllowed = SemverIgnoreTransform.asSeverity(node.path("versionIncreaseAllows").path("minor"), DifferenceSeverity.BREAKING);
                DifferenceSeverity patchVersionAllowed = SemverIgnoreTransform.asSeverity(node.path("versionIncreaseAllows").path("patch"), DifferenceSeverity.NON_BREAKING);
                this.allowedSeverity = newVersion.minor > oldVersion.minor ? minorChangeAllowed : (newVersion.minor == oldVersion.minor && newVersion.patch > oldVersion.patch ? patchVersionAllowed : null);
            } else {
                DifferenceSeverity majorChangeAllowed = SemverIgnoreTransform.asSeverity(node.path("versionIncreaseAllows").path("major"), DifferenceSeverity.BREAKING);
                DifferenceSeverity minorChangeAllowed = SemverIgnoreTransform.asSeverity(node.path("versionIncreaseAllows").path("minor"), DifferenceSeverity.NON_BREAKING);
                DifferenceSeverity patchVersionAllowed = SemverIgnoreTransform.asSeverity(node.path("versionIncreaseAllows").path("patch"), DifferenceSeverity.EQUIVALENT);
                this.allowedSeverity = newVersion.major > oldVersion.major ? majorChangeAllowed : (newVersion.major == oldVersion.major && newVersion.minor > oldVersion.minor ? minorChangeAllowed : patchVersionAllowed);
            }
            this.passThroughDifferences = Collections.emptyList();
            if (node.hasNonNull("passThroughDifferences")) {
                this.passThroughDifferences = StreamSupport.stream(node.path("passThroughDifferences").spliterator(), false).map(JsonNode::asText).collect(Collectors.toList());
            }
        }
        if (this.enabled) {
            LOG.warn("revapi.semver.ignore transform has been deprecated. Please use the new revapi.versions which has better integration with the new Revapi features.");
        }
    }

    private boolean hasMultipleElements(Iterable<?> it) {
        Iterator<?> i = it.iterator();
        if (!i.hasNext()) {
            return false;
        }
        i.next();
        return i.hasNext();
    }

    private static DifferenceSeverity asSeverity(JsonNode configNode, DifferenceSeverity defaultValue) {
        if (configNode.isMissingNode()) {
            return defaultValue;
        }
        switch (configNode.asText()) {
            case "none": {
                return null;
            }
            case "equivalent": {
                return DifferenceSeverity.EQUIVALENT;
            }
            case "nonBreaking": {
                return DifferenceSeverity.NON_BREAKING;
            }
            case "potentiallyBreaking": {
                return DifferenceSeverity.POTENTIALLY_BREAKING;
            }
            case "breaking": {
                return DifferenceSeverity.BREAKING;
            }
        }
        return defaultValue;
    }
}

