/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.spi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleAnnotationValueVisitor7;
import javax.lang.model.util.SimpleElementVisitor7;
import javax.lang.model.util.SimpleTypeVisitor7;
import javax.lang.model.util.Types;
import org.revapi.java.spi.IgnoreCompletionFailures;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Util {
    private static final Logger LOG = LoggerFactory.getLogger(Util.class);
    private static SimpleTypeVisitor7<Void, StringBuilderAndState<TypeMirror>> toUniqueStringVisitor = new SimpleTypeVisitor7<Void, StringBuilderAndState<TypeMirror>>(){

        @Override
        public Void visitPrimitive(PrimitiveType t, StringBuilderAndState<TypeMirror> state) {
            switch (t.getKind()) {
                case BOOLEAN: {
                    state.bld.append("boolean");
                    break;
                }
                case BYTE: {
                    state.bld.append("byte");
                    break;
                }
                case CHAR: {
                    state.bld.append("char");
                    break;
                }
                case DOUBLE: {
                    state.bld.append("double");
                    break;
                }
                case FLOAT: {
                    state.bld.append("float");
                    break;
                }
                case INT: {
                    state.bld.append("int");
                    break;
                }
                case LONG: {
                    state.bld.append("long");
                    break;
                }
                case SHORT: {
                    state.bld.append("short");
                    break;
                }
            }
            return null;
        }

        @Override
        public Void visitArray(ArrayType t, StringBuilderAndState<TypeMirror> bld) {
            IgnoreCompletionFailures.in(t::getComponentType).accept(this, bld);
            bld.bld.append("[]");
            return null;
        }

        @Override
        public Void visitTypeVariable(TypeVariable t, StringBuilderAndState<TypeMirror> state) {
            if (state.visitedObjects.contains(t)) {
                state.bld.append("%");
                return null;
            }
            state.visitedObjects.add(t);
            TypeMirror lowerBound = IgnoreCompletionFailures.in(t::getLowerBound);
            if (lowerBound != null && lowerBound.getKind() != TypeKind.NULL) {
                lowerBound.accept(this, state);
                state.bld.append("-");
            }
            IgnoreCompletionFailures.in(t::getUpperBound).accept(this, state);
            state.bld.append("+");
            return null;
        }

        @Override
        public Void visitWildcard(WildcardType t, StringBuilderAndState<TypeMirror> state) {
            TypeMirror superBound = IgnoreCompletionFailures.in(t::getSuperBound);
            if (superBound != null) {
                superBound.accept(this, state);
                state.bld.append("-");
            }
            TypeMirror extendsBound = IgnoreCompletionFailures.in(t::getExtendsBound);
            if (extendsBound != null) {
                extendsBound.accept(this, state);
                state.bld.append("+");
            }
            return null;
        }

        @Override
        public Void visitExecutable(ExecutableType t, StringBuilderAndState<TypeMirror> state) {
            this.visitTypeVars(IgnoreCompletionFailures.in(t::getTypeVariables), state);
            IgnoreCompletionFailures.in(t::getReturnType).accept(this, state);
            state.bld.append("(");
            Iterator it = IgnoreCompletionFailures.in(t::getParameterTypes).iterator();
            if (it.hasNext()) {
                ((TypeMirror)it.next()).accept(this, state);
            }
            while (it.hasNext()) {
                state.bld.append(",");
                ((TypeMirror)it.next()).accept(this, state);
            }
            state.bld.append(")");
            List thrownTypes = IgnoreCompletionFailures.in(t::getThrownTypes);
            if (!thrownTypes.isEmpty()) {
                state.bld.append("throws:");
                it = thrownTypes.iterator();
                ((TypeMirror)it.next()).accept(this, state);
                while (it.hasNext()) {
                    state.bld.append(",");
                    ((TypeMirror)it.next()).accept(this, state);
                }
            }
            return null;
        }

        @Override
        public Void visitNoType(NoType t, StringBuilderAndState<TypeMirror> state) {
            switch (t.getKind()) {
                case VOID: {
                    state.bld.append("void");
                    break;
                }
                case PACKAGE: {
                    state.bld.append("package");
                    break;
                }
            }
            return null;
        }

        @Override
        public Void visitDeclared(DeclaredType t, StringBuilderAndState<TypeMirror> state) {
            Name name = ((TypeElement)t.asElement()).getQualifiedName();
            state.bld.append(name);
            this.visitTypeVars(IgnoreCompletionFailures.in(t::getTypeArguments), state);
            return null;
        }

        @Override
        public Void visitError(ErrorType t, StringBuilderAndState<TypeMirror> state) {
            state.bld.append(((TypeElement)t.asElement()).getQualifiedName());
            return null;
        }

        private void visitTypeVars(List<? extends TypeMirror> vars, StringBuilderAndState<TypeMirror> state) {
            if (!vars.isEmpty()) {
                state.bld.append("<");
                Iterator<? extends TypeMirror> it = vars.iterator();
                it.next().accept(this, state);
                while (it.hasNext()) {
                    state.bld.append(",");
                    it.next().accept(this, state);
                }
                state.bld.append(">");
            }
        }
    };
    private static SimpleTypeVisitor7<Void, StringBuilderAndState<TypeMirror>> toHumanReadableStringVisitor = new SimpleTypeVisitor7<Void, StringBuilderAndState<TypeMirror>>(){

        @Override
        public Void visitPrimitive(PrimitiveType t, StringBuilderAndState<TypeMirror> state) {
            switch (t.getKind()) {
                case BOOLEAN: {
                    state.bld.append("boolean");
                    break;
                }
                case BYTE: {
                    state.bld.append("byte");
                    break;
                }
                case CHAR: {
                    state.bld.append("char");
                    break;
                }
                case DOUBLE: {
                    state.bld.append("double");
                    break;
                }
                case FLOAT: {
                    state.bld.append("float");
                    break;
                }
                case INT: {
                    state.bld.append("int");
                    break;
                }
                case LONG: {
                    state.bld.append("long");
                    break;
                }
                case SHORT: {
                    state.bld.append("short");
                    break;
                }
            }
            return null;
        }

        @Override
        public Void visitArray(ArrayType t, StringBuilderAndState<TypeMirror> state) {
            IgnoreCompletionFailures.in(t::getComponentType).accept(this, state);
            state.bld.append("[]");
            return null;
        }

        @Override
        public Void visitTypeVariable(TypeVariable t, StringBuilderAndState<TypeMirror> state) {
            if (state.visitedObjects.contains(t)) {
                state.bld.append(t.asElement().getSimpleName());
                return null;
            }
            state.visitedObjects.add(t);
            state.bld.append(t.asElement().getSimpleName());
            if (!state.visitingMethod) {
                TypeMirror lowerBound = IgnoreCompletionFailures.in(t::getLowerBound);
                if (lowerBound != null && lowerBound.getKind() != TypeKind.NULL) {
                    state.bld.append(" super ");
                    lowerBound.accept(this, state);
                }
                state.bld.append(" extends ");
                IgnoreCompletionFailures.in(t::getUpperBound).accept(this, state);
            }
            return null;
        }

        @Override
        public Void visitWildcard(WildcardType t, StringBuilderAndState<TypeMirror> state) {
            state.bld.append("?");
            TypeMirror superBound = IgnoreCompletionFailures.in(t::getSuperBound);
            if (superBound != null) {
                state.bld.append(" super ");
                superBound.accept(this, state);
            }
            TypeMirror extendsBound = IgnoreCompletionFailures.in(t::getExtendsBound);
            if (extendsBound != null) {
                state.bld.append(" extends ");
                extendsBound.accept(this, state);
            }
            return null;
        }

        @Override
        public Void visitExecutable(ExecutableType t, StringBuilderAndState<TypeMirror> state) {
            this.visitTypeVars(IgnoreCompletionFailures.in(t::getTypeVariables), state);
            state.visitingMethod = true;
            IgnoreCompletionFailures.in(t::getReturnType).accept(this, state);
            state.bld.append("(");
            Iterator it = IgnoreCompletionFailures.in(t::getParameterTypes).iterator();
            if (it.hasNext()) {
                ((TypeMirror)it.next()).accept(this, state);
            }
            while (it.hasNext()) {
                state.bld.append(", ");
                ((TypeMirror)it.next()).accept(this, state);
            }
            state.bld.append(")");
            List thrownTypes = IgnoreCompletionFailures.in(t::getThrownTypes);
            if (!thrownTypes.isEmpty()) {
                state.bld.append(" throws ");
                it = thrownTypes.iterator();
                ((TypeMirror)it.next()).accept(this, state);
                while (it.hasNext()) {
                    state.bld.append(", ");
                    ((TypeMirror)it.next()).accept(this, state);
                }
            }
            state.visitingMethod = false;
            return null;
        }

        @Override
        public Void visitNoType(NoType t, StringBuilderAndState<TypeMirror> state) {
            switch (t.getKind()) {
                case VOID: {
                    state.bld.append("void");
                    break;
                }
                case PACKAGE: {
                    state.bld.append("package");
                    break;
                }
            }
            return null;
        }

        @Override
        public Void visitDeclared(DeclaredType t, StringBuilderAndState<TypeMirror> state) {
            Name name = ((TypeElement)t.asElement()).getQualifiedName();
            state.bld.append(name);
            try {
                this.visitTypeVars(IgnoreCompletionFailures.in(t::getTypeArguments), state);
            }
            catch (RuntimeException e) {
                LOG.debug("Failed to enumerate type arguments of '" + name + "'. Class is missing?", (Throwable)e);
            }
            return null;
        }

        private void visitTypeVars(List<? extends TypeMirror> vars, StringBuilderAndState<TypeMirror> state) {
            if (!vars.isEmpty()) {
                state.bld.append("<");
                Iterator<? extends TypeMirror> it = vars.iterator();
                it.next().accept(this, state);
                while (it.hasNext()) {
                    state.bld.append(", ");
                    it.next().accept(this, state);
                }
                state.bld.append(">");
            }
        }
    };
    private static SimpleElementVisitor7<Void, StringBuilderAndState<TypeMirror>> toHumanReadableStringElementVisitor = new SimpleElementVisitor7<Void, StringBuilderAndState<TypeMirror>>(){

        @Override
        public Void visitVariable(VariableElement e, StringBuilderAndState<TypeMirror> state) {
            Element enclosing = e.getEnclosingElement();
            if (enclosing instanceof TypeElement) {
                enclosing.accept(this, state);
                state.bld.append(".").append(e.getSimpleName());
            } else if (enclosing instanceof ExecutableElement) {
                if (state.visitingMethod) {
                    e.asType().accept(toHumanReadableStringVisitor, state);
                } else {
                    int paramIdx = ((ExecutableElement)enclosing).getParameters().indexOf(e);
                    enclosing.accept(this, state);
                    int openPar = state.bld.indexOf("(");
                    int closePar = state.bld.indexOf(")", openPar);
                    int paramStart = openPar + 1;
                    int curParIdx = -1;
                    for (int i = openPar + 1; i < closePar; ++i) {
                        if (state.bld.charAt(i) != ',') continue;
                        if (++curParIdx == paramIdx) {
                            String par = state.bld.substring(paramStart, i);
                            state.bld.replace(paramStart, i, "===" + par + "===");
                            continue;
                        }
                        paramStart = i + (paramIdx == 0 ? 1 : 2);
                    }
                    if (++curParIdx == paramIdx) {
                        String par = state.bld.substring(paramStart, closePar);
                        state.bld.replace(paramStart, closePar, "===" + par + "===");
                    }
                }
            } else {
                state.bld.append(e.getSimpleName());
            }
            return null;
        }

        @Override
        public Void visitPackage(PackageElement e, StringBuilderAndState<TypeMirror> state) {
            state.bld.append(e.getQualifiedName());
            return null;
        }

        @Override
        public Void visitType(TypeElement e, StringBuilderAndState<TypeMirror> state) {
            state.bld.append(e.getQualifiedName());
            List typePars = IgnoreCompletionFailures.in(e::getTypeParameters);
            if (typePars.size() > 0) {
                state.bld.append("<");
                ((TypeParameterElement)typePars.get(0)).accept(this, state);
                for (int i = 1; i < typePars.size(); ++i) {
                    state.bld.append(", ");
                    ((TypeParameterElement)typePars.get(i)).accept(this, state);
                }
                state.bld.append(">");
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void visitExecutable(ExecutableElement e, StringBuilderAndState<TypeMirror> state) {
            state.visitingMethod = true;
            try {
                List typePars = IgnoreCompletionFailures.in(e::getTypeParameters);
                if (typePars.size() > 0) {
                    state.bld.append("<");
                    ((TypeParameterElement)typePars.get(0)).accept(this, state);
                    for (int i = 1; i < typePars.size(); ++i) {
                        state.bld.append(", ");
                        ((TypeParameterElement)typePars.get(i)).accept(this, state);
                    }
                    state.bld.append("> ");
                }
                IgnoreCompletionFailures.in(e::getReturnType).accept(toHumanReadableStringVisitor, state);
                state.bld.append(" ");
                e.getEnclosingElement().accept(this, state);
                state.bld.append("::").append(e.getSimpleName()).append("(");
                List pars = IgnoreCompletionFailures.in(e::getParameters);
                if (pars.size() > 0) {
                    ((VariableElement)pars.get(0)).accept(this, state);
                    for (int i = 1; i < pars.size(); ++i) {
                        state.bld.append(", ");
                        ((VariableElement)pars.get(i)).accept(this, state);
                    }
                }
                state.bld.append(")");
                List thrownTypes = IgnoreCompletionFailures.in(e::getThrownTypes);
                if (thrownTypes.size() > 0) {
                    state.bld.append(" throws ");
                    ((TypeMirror)thrownTypes.get(0)).accept(toHumanReadableStringVisitor, state);
                    for (int i = 1; i < thrownTypes.size(); ++i) {
                        state.bld.append(", ");
                        ((TypeMirror)thrownTypes.get(i)).accept(toHumanReadableStringVisitor, state);
                    }
                }
                Void void_ = null;
                return void_;
            }
            finally {
                state.visitingMethod = false;
            }
        }

        @Override
        public Void visitTypeParameter(TypeParameterElement e, StringBuilderAndState<TypeMirror> state) {
            state.bld.append(e.getSimpleName());
            List bounds = IgnoreCompletionFailures.in(e::getBounds);
            if (bounds.size() > 0) {
                if (bounds.size() == 1) {
                    TypeMirror firstBound = (TypeMirror)bounds.get(0);
                    String bs = Util.toHumanReadableString(firstBound);
                    if (!"java.lang.Object".equals(bs)) {
                        state.bld.append(" extends ").append(bs);
                    }
                } else {
                    state.bld.append(" extends ");
                    ((TypeMirror)bounds.get(0)).accept(toHumanReadableStringVisitor, state);
                    for (int i = 1; i < bounds.size(); ++i) {
                        state.bld.append(", ");
                        ((TypeMirror)bounds.get(i)).accept(toHumanReadableStringVisitor, state);
                    }
                }
            }
            return null;
        }
    };

    private Util() {
    }

    public static boolean isSameType(@Nonnull TypeMirror t1, @Nonnull TypeMirror t2) {
        String t1Name = Util.toUniqueString(t1);
        String t2Name = Util.toUniqueString(t2);
        return t1Name.equals(t2Name);
    }

    @Nonnull
    public static String toHumanReadableString(@Nonnull Element element) {
        StringBuilderAndState state = new StringBuilderAndState();
        element.accept(toHumanReadableStringElementVisitor, state);
        return state.bld.toString();
    }

    @Nonnull
    public static String toUniqueString(@Nonnull TypeMirror t) {
        StringBuilderAndState state = new StringBuilderAndState();
        t.accept(toUniqueStringVisitor, state);
        return state.bld.toString();
    }

    @Nonnull
    public static String toHumanReadableString(@Nonnull TypeMirror t) {
        StringBuilderAndState state = new StringBuilderAndState();
        t.accept(toHumanReadableStringVisitor, state);
        return state.bld.toString();
    }

    @Nonnull
    public static String toUniqueString(@Nonnull AnnotationValue v) {
        return Util.toHumanReadableString(v);
    }

    @Nonnull
    public static String toHumanReadableString(@Nonnull AnnotationValue v) {
        return v.accept(new SimpleAnnotationValueVisitor7<String, Void>(){

            @Override
            protected String defaultAction(Object o, Void ignored) {
                return o.toString();
            }

            @Override
            public String visitType(TypeMirror t, Void ignored) {
                return Util.toHumanReadableString(t) + ".class";
            }

            @Override
            public String visitEnumConstant(VariableElement c, Void ignored) {
                return Util.toHumanReadableString(c.asType()) + "." + c.getSimpleName().toString();
            }

            @Override
            public String visitAnnotation(AnnotationMirror a, Void ignored) {
                StringBuilder bld = new StringBuilder("@").append(Util.toHumanReadableString(a.getAnnotationType()));
                if (!a.getElementValues().isEmpty()) {
                    bld.append("(");
                    for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : a.getElementValues().entrySet()) {
                        bld.append(e.getKey().getSimpleName().toString()).append(" = ");
                        bld.append(e.getValue().accept(this, null));
                        bld.append(", ");
                    }
                    bld.replace(bld.length() - 2, bld.length(), "");
                    bld.append(")");
                }
                return bld.toString();
            }

            @Override
            public String visitArray(List<? extends AnnotationValue> vals, Void ignored) {
                StringBuilder bld = new StringBuilder("[");
                Iterator<? extends AnnotationValue> it = vals.iterator();
                if (it.hasNext()) {
                    bld.append(it.next().accept(this, null));
                }
                while (it.hasNext()) {
                    bld.append(", ").append(it.next().accept(this, null));
                }
                bld.append("]");
                return bld.toString();
            }
        }, null);
    }

    @Nonnull
    public static List<TypeMirror> getAllSuperClasses(@Nonnull Types types, @Nonnull TypeMirror type) {
        ArrayList<TypeMirror> ret = new ArrayList<TypeMirror>();
        try {
            List<? extends TypeMirror> superTypes = types.directSupertypes(type);
            while (superTypes != null && !superTypes.isEmpty()) {
                TypeMirror superClass = superTypes.get(0);
                ret.add(superClass);
                superTypes = types.directSupertypes(superClass);
            }
        }
        catch (RuntimeException e) {
            LOG.debug("Failed to find all super classes of type '" + Util.toHumanReadableString(type) + ". Possibly " + "missing classes?", (Throwable)e);
        }
        return ret;
    }

    @Nonnull
    public static List<TypeMirror> getAllSuperTypes(@Nonnull Types types, @Nonnull TypeMirror type) {
        ArrayList<TypeMirror> ret = new ArrayList<TypeMirror>();
        Util.fillAllSuperTypes(types, type, ret);
        return ret;
    }

    public static void fillAllSuperTypes(@Nonnull Types types, @Nonnull TypeMirror type, @Nonnull List<TypeMirror> result) {
        try {
            List<? extends TypeMirror> superTypes = types.directSupertypes(type);
            for (TypeMirror typeMirror : superTypes) {
                result.add(typeMirror);
                Util.fillAllSuperTypes(types, typeMirror, result);
            }
        }
        catch (RuntimeException e) {
            LOG.debug("Failed to find all super types of type '" + Util.toHumanReadableString(type) + ". Possibly " + "missing classes?", (Throwable)e);
        }
    }

    public static boolean isSubtype(@Nonnull TypeMirror type, @Nonnull List<? extends TypeMirror> superTypes, @Nonnull Types typeEnvironment) {
        List<TypeMirror> typeSuperTypes = Util.getAllSuperTypes(typeEnvironment, type);
        typeSuperTypes.add(0, type);
        for (TypeMirror t : typeSuperTypes) {
            String oldi = Util.toUniqueString(t);
            for (TypeMirror typeMirror : superTypes) {
                String newi = Util.toUniqueString(typeMirror);
                if (!oldi.equals(newi)) continue;
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public static Map<String, Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> keyAnnotationAttributesByName(@Nonnull Map<? extends ExecutableElement, ? extends AnnotationValue> attributes) {
        LinkedHashMap<String, Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> result = new LinkedHashMap<String, Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>>();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : attributes.entrySet()) {
            result.put(e.getKey().getSimpleName().toString(), e);
        }
        return result;
    }

    public static boolean isEqual(@Nonnull AnnotationValue oldVal, @Nonnull AnnotationValue newVal) {
        return oldVal.accept(new SimpleAnnotationValueVisitor7<Boolean, Object>(){

            @Override
            protected Boolean defaultAction(Object o, Object o2) {
                return o.equals(o2);
            }

            @Override
            public Boolean visitType(TypeMirror t, Object o) {
                if (!(o instanceof TypeMirror)) {
                    return false;
                }
                String os = Util.toUniqueString(t);
                String ns = Util.toUniqueString((TypeMirror)o);
                return os.equals(ns);
            }

            @Override
            public Boolean visitEnumConstant(VariableElement c, Object o) {
                return o instanceof VariableElement && c.getSimpleName().toString().equals(((VariableElement)o).getSimpleName().toString());
            }

            @Override
            public Boolean visitAnnotation(AnnotationMirror a, Object o) {
                String nt;
                if (!(o instanceof AnnotationMirror)) {
                    return false;
                }
                AnnotationMirror oa = (AnnotationMirror)o;
                String ot = Util.toUniqueString(a.getAnnotationType());
                if (!ot.equals(nt = Util.toUniqueString(oa.getAnnotationType()))) {
                    return false;
                }
                if (a.getElementValues().size() != oa.getElementValues().size()) {
                    return false;
                }
                Map<String, Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> aVals = Util.keyAnnotationAttributesByName(a.getElementValues());
                Map<String, Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> oVals = Util.keyAnnotationAttributesByName(oa.getElementValues());
                for (Map.Entry<String, Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> aVal : aVals.entrySet()) {
                    String os;
                    String name = aVal.getKey();
                    Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> aAttr = aVal.getValue();
                    Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> oAttr = oVals.get(name);
                    if (oAttr == null) {
                        return false;
                    }
                    String as = Util.toUniqueString(aAttr.getValue());
                    if (as.equals(os = Util.toUniqueString(oAttr.getValue()))) continue;
                    return false;
                }
                return true;
            }

            @Override
            public Boolean visitArray(List<? extends AnnotationValue> vals, Object o) {
                if (!(o instanceof List)) {
                    return false;
                }
                List ovals = (List)o;
                if (vals.size() != ovals.size()) {
                    return false;
                }
                for (int i = 0; i < vals.size(); ++i) {
                    if (vals.get(i).accept(this, ((AnnotationValue)ovals.get(i)).getValue()).booleanValue()) continue;
                    return false;
                }
                return true;
            }
        }, newVal.getValue());
    }

    public static TypeElement findTypeByBinaryName(Elements elements, String binaryName) {
        return Util.findTypeByBinaryName(elements, binaryName, 0);
    }

    private static TypeElement findTypeByBinaryName(Elements elements, String binaryName, int swapStartPos) {
        TypeElement ret;
        String attemptedName = binaryName;
        if (swapStartPos >= binaryName.length()) {
            return null;
        }
        if (attemptedName.indexOf(36, swapStartPos) == -1) {
            return elements.getTypeElement(attemptedName);
        }
        int dollarPos = swapStartPos;
        while ((ret = elements.getTypeElement(attemptedName)) == null && (dollarPos = attemptedName.indexOf(36, dollarPos)) != -1) {
            if (dollarPos >= binaryName.length()) continue;
            attemptedName = attemptedName.substring(0, dollarPos) + "." + attemptedName.substring(dollarPos + 1);
        }
        if (ret == null && (dollarPos = binaryName.indexOf(36, swapStartPos)) != -1 && (ret = Util.findTypeByBinaryName(elements, binaryName, dollarPos + 1)) == null) {
            binaryName = binaryName.substring(0, dollarPos) + "." + binaryName.substring(dollarPos + 1);
            ret = Util.findTypeByBinaryName(elements, binaryName, swapStartPos + 1);
        }
        return ret;
    }

    private static class StringBuilderAndState<T> {
        final StringBuilder bld = new StringBuilder();
        final Set<T> visitedObjects = new HashSet<T>();
        boolean visitingMethod;

        private StringBuilderAndState() {
        }
    }
}

