/*
 * Decompiled with CFR 0.152.
 */
package org.rxjava.security.example.config;

import java.util.Collection;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.UserDetails;

public class JwtAuthenticationToken
extends AbstractAuthenticationToken {
    private UserDetails principal;
    private String jwtToken;

    public JwtAuthenticationToken(String token) {
        super((Collection)AuthorityUtils.NO_AUTHORITIES);
        this.jwtToken = token;
    }

    public JwtAuthenticationToken(UserDetails principal, String jwtToken, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        this.principal = principal;
        this.jwtToken = jwtToken;
        this.setAuthenticated(true);
    }

    public Object getCredentials() {
        return this.jwtToken;
    }

    public Object getPrincipal() {
        return this.principal;
    }
}

