/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.lw3d;

import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.lw3d.LwsFrame;
import com.sun.j3d.loaders.lw3d.LwsMotion;
import com.sun.j3d.loaders.lw3d.LwsPrimitive;
import com.sun.j3d.loaders.lw3d.TextfileParser;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Vector;
import javax.media.j3d.Behavior;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Matrix4d;

class LwsCamera
extends TextfileParser
implements LwsPrimitive {
    String fileName;
    String objName;
    LwsMotion motion;
    int parent;
    TransformGroup objectTransform;
    Vector objectBehavior;

    LwsCamera(StreamTokenizer st, int firstFrame, int totalFrames, float totalTime, int debugVals) throws ParsingErrorException {
        this.debugPrinter.setValidOutput(debugVals);
        this.parent = -1;
        this.getNumber(st);
        this.getNumber(st);
        this.getAndCheckString(st, "CameraMotion");
        this.motion = new LwsMotion(st, firstFrame, totalFrames, totalTime, this.debugPrinter.getValidOutput());
        while (!this.isCurrentToken(st, "DepthOfField")) {
            this.debugOutputLn(8, "currentToken = " + st.sval);
            if (this.isCurrentToken(st, "ParentObject")) {
                this.parent = (int)this.getNumber(st);
            }
            try {
                st.nextToken();
            }
            catch (IOException e) {
                throw new ParsingErrorException(e.getMessage());
            }
        }
        this.getNumber(st);
    }

    int getParent() {
        return this.parent;
    }

    void createJava3dObject(int loadBehaviors) {
        Matrix4d mat = new Matrix4d();
        mat.setIdentity();
        LwsFrame firstFrame = this.motion.getFirstFrame();
        firstFrame.setMatrix(mat);
        this.debugOutputLn(2, "  Camera Matrix = \n" + mat);
        Transform3D t1 = new Transform3D();
        Matrix4d m = new Matrix4d();
        double scale = 0.1;
        m.setColumn(0, scale, 0.0, 0.0, 0.0);
        m.setColumn(1, 0.0, scale, 0.0, 0.0);
        m.setColumn(2, 0.0, 0.0, scale, 0.0);
        m.setColumn(3, 0.0, 0.0, 0.0, 1.0);
        Transform3D scaleTrans = new Transform3D(m);
        TransformGroup scaleGroup = new TransformGroup(scaleTrans);
        scaleGroup.setCapability(18);
        scaleGroup.setCapability(17);
        t1.set(mat);
        this.objectTransform = new TransformGroup(t1);
        this.objectTransform.setCapability(18);
        this.objectBehavior = new Vector();
        if (loadBehaviors != 0) {
            this.motion.createJava3dBehaviors(this.objectTransform);
            Behavior b = this.motion.getBehaviors();
            if (b != null) {
                this.objectBehavior.addElement(b);
            }
        }
    }

    @Override
    public TransformGroup getObjectNode() {
        return this.objectTransform;
    }

    @Override
    public Vector getObjectBehaviors() {
        this.debugOutputLn(1, "getObjectBehaviors()");
        return this.objectBehavior;
    }

    void printVals() {
        System.out.println("   objName = " + this.objName);
        this.motion.printVals();
    }
}

