/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.sensor;

import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.Material;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class SensorBeamEcho
extends Shape3D {
    public SensorBeamEcho(Point3d hotspot, double baseWidth, boolean enableLighting) {
        int vertexFormat;
        if (hotspot.distance(new Point3d()) == 0.0) {
            throw new IllegalArgumentException("\nBeam echo can't have hotspot at origin");
        }
        Vector3f axis = new Vector3f((float)hotspot.x, (float)hotspot.y, (float)hotspot.z);
        Vector3f axis1 = new Vector3f();
        axis1.normalize(axis);
        Vector3f normal = new Vector3f(0.0f, 1.0f, 0.0f);
        normal.cross(axis1, normal);
        if (normal.lengthSquared() < 0.5f) {
            normal.set(0.0f, 0.0f, 1.0f);
            normal.cross(axis1, normal);
        }
        normal.normalize();
        int divisions = 18;
        Point3f[] cap0 = new Point3f[divisions];
        Point3f[] cap1 = new Point3f[divisions];
        Vector3f[] capNormals = new Vector3f[divisions];
        Vector3f cap0Normal = new Vector3f(axis1);
        Vector3f cap1Normal = new Vector3f(axis1);
        cap0Normal.negate();
        AxisAngle4f aa4f = new AxisAngle4f(axis1, (float)(-Math.PI) / ((float)divisions / 2.0f));
        Transform3D t3d = new Transform3D();
        t3d.set(aa4f);
        float halfWidth = (float)baseWidth / 2.0f;
        for (int i = 0; i < divisions; ++i) {
            capNormals[i] = new Vector3f(normal);
            cap0[i] = new Point3f((Tuple3f)normal);
            cap0[i].scale(halfWidth);
            cap1[i] = new Point3f(cap0[i]);
            cap1[i].add((Tuple3f)axis);
            t3d.transform(normal);
        }
        int vertexCount = 2 + 4 * divisions;
        Point3f[] vertices = new Point3f[vertexCount];
        Vector3f[] normals = new Vector3f[vertexCount];
        for (int i = 0; i < divisions; ++i) {
            vertices[i * 2] = cap0[i];
            vertices[i * 2 + 1] = cap1[i];
            normals[i * 2] = capNormals[i];
            normals[i * 2 + 1] = capNormals[i];
        }
        vertices[divisions * 2] = cap0[0];
        vertices[divisions * 2 + 1] = cap1[0];
        normals[divisions * 2] = capNormals[0];
        normals[divisions * 2 + 1] = capNormals[0];
        int v = (divisions + 1) * 2;
        vertices[v] = cap0[0];
        normals[v++] = cap0Normal;
        int j = 1;
        int k = divisions - 1;
        while (j <= k) {
            vertices[v] = cap0[j++];
            normals[v++] = cap0Normal;
            if (j > k) break;
            vertices[v] = cap0[k--];
            normals[v++] = cap0Normal;
        }
        vertices[v] = cap1[0];
        normals[v++] = cap1Normal;
        j = 1;
        k = divisions - 1;
        while (j <= k) {
            vertices[v] = cap1[k--];
            normals[v++] = cap1Normal;
            if (j > k) break;
            vertices[v] = cap1[j++];
            normals[v++] = cap1Normal;
        }
        Material m = new Material();
        m.setCapability(0);
        m.setCapability(1);
        if (enableLighting) {
            vertexFormat = 3;
            m.setLightingEnable(true);
        } else {
            vertexFormat = 1;
            m.setLightingEnable(false);
        }
        int[] stripCounts = new int[]{2 + 2 * divisions, divisions, divisions};
        TriangleStripArray tsa = new TriangleStripArray(vertexCount, vertexFormat, stripCounts);
        tsa.setCoordinates(0, vertices);
        if (enableLighting) {
            tsa.setNormals(0, normals);
        }
        Appearance a = new Appearance();
        a.setMaterial(m);
        a.setCapability(0);
        a.setCapability(1);
        TransparencyAttributes ta = new TransparencyAttributes();
        ta.setCapability(0);
        ta.setCapability(1);
        ta.setCapability(2);
        ta.setCapability(3);
        ta.setCapability(4);
        ta.setCapability(5);
        a.setTransparencyAttributes(ta);
        a.setCapability(10);
        a.setCapability(11);
        this.setGeometry((Geometry)tsa);
        this.setAppearance(a);
        this.setCapability(14);
        this.setCapability(15);
    }
}

