/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.compression;

import com.sun.j3d.utils.compression.CommandStream;
import com.sun.j3d.utils.compression.CompressedGeometryFile;
import com.sun.j3d.utils.compression.CompressionStream;
import com.sun.j3d.utils.compression.HuffmanTable;
import java.io.IOException;
import javax.media.j3d.CompressedGeometry;
import javax.media.j3d.CompressedGeometryHeader;
import javax.vecmath.Point3d;

public class GeometryCompressor {
    private static final boolean benchmark = false;
    private static final boolean printStream = false;
    private static final boolean printHuffman = false;
    private HuffmanTable huffmanTable;
    private CommandStream outputBuffer;
    private CompressedGeometryHeader cgHeader = new CompressedGeometryHeader();
    private long startTime;

    public GeometryCompressor() {
        this.cgHeader.majorVersionNumber = 1;
        this.cgHeader.minorVersionNumber = 0;
        this.cgHeader.minorMinorVersionNumber = 2;
    }

    public CompressedGeometry compress(CompressionStream stream) {
        this.compressStream(stream);
        CompressedGeometry cg = new CompressedGeometry(this.cgHeader, this.outputBuffer.getBytes());
        this.outputBuffer.clear();
        return cg;
    }

    public void compress(CompressionStream stream, CompressedGeometryFile f) throws IOException {
        this.compressStream(stream);
        f.write(this.cgHeader, this.outputBuffer.getBytes());
        this.outputBuffer.clear();
    }

    private void compressStream(CompressionStream stream) {
        this.huffmanTable = new HuffmanTable();
        stream.quantize(this.huffmanTable);
        this.huffmanTable.computeTags();
        this.outputBuffer = new CommandStream(stream.getByteCount() / 3);
        stream.outputCommands(this.huffmanTable, this.outputBuffer);
        this.cgHeader.bufferType = stream.streamType;
        this.cgHeader.bufferDataPresent = 0;
        this.cgHeader.lowerBound = new Point3d(stream.ncBounds[0]);
        this.cgHeader.upperBound = new Point3d(stream.ncBounds[1]);
        if (stream.vertexNormals) {
            this.cgHeader.bufferDataPresent |= 1;
        }
        if (stream.vertexColor3 || stream.vertexColor4) {
            this.cgHeader.bufferDataPresent |= 2;
        }
        if (stream.vertexColor4) {
            this.cgHeader.bufferDataPresent |= 4;
        }
        this.cgHeader.start = 0;
        this.cgHeader.size = this.outputBuffer.getByteCount();
        this.huffmanTable.clear();
    }

    private void printBench(CompressionStream stream) {
        long t = System.currentTimeMillis() - this.startTime;
        int vertexCount = stream.getVertexCount();
        int meshReferenceCount = stream.getMeshReferenceCount();
        int totalVertices = meshReferenceCount + vertexCount;
        float meshPercent = 100.0f * (float)meshReferenceCount / (float)totalVertices;
        float compressionRatio = (float)stream.getByteCount() / (float)this.outputBuffer.getByteCount();
        int vertexBytes = 12 + (stream.vertexColor3 ? 12 : 0) + (stream.vertexColor4 ? 16 : 0) + (stream.vertexNormals ? 12 : 0);
        float compressedVertexBytes = (float)this.outputBuffer.getByteCount() / (float)totalVertices;
        System.out.println("\nGeometryCompressor:\n" + totalVertices + " total vertices\n" + vertexCount + " streamed vertices\n" + meshReferenceCount + " mesh buffer references (" + meshPercent + "%)\n" + stream.getByteCount() + " bytes streamed geometry compressed to " + this.outputBuffer.getByteCount() + " in " + (float)t / 1000.0f + " sec\n" + (float)stream.getByteCount() / (float)t + " kbytes/sec, " + "stream compression ratio " + compressionRatio + "\n\n" + vertexBytes + " original bytes per vertex, " + compressedVertexBytes + " compressed bytes per vertex\n" + "total vertex compression ratio " + (float)vertexBytes / compressedVertexBytes + "\n\n" + "lower bound " + stream.ncBounds[0].toString() + "\n" + "upper bound " + stream.ncBounds[1].toString());
    }
}

