/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.InterpolatorState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.Alpha;
import javax.media.j3d.ColorInterpolator;
import javax.media.j3d.Material;
import javax.media.j3d.SceneGraphObject;
import javax.vecmath.Color3f;

public class ColorInterpolatorState
extends InterpolatorState {
    private int target;

    public ColorInterpolatorState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
        if (this.node != null) {
            this.target = control.getSymbolTable().addReference((SceneGraphObject)((ColorInterpolator)this.node).getTarget());
        }
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        out.writeInt(this.target);
        Color3f clr = new Color3f();
        ((ColorInterpolator)this.node).getStartColor(clr);
        this.control.writeColor3f(out, clr);
        ((ColorInterpolator)this.node).getEndColor(clr);
        this.control.writeColor3f(out, clr);
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        this.target = in.readInt();
        ((ColorInterpolator)this.node).setStartColor(this.control.readColor3f(in));
        ((ColorInterpolator)this.node).setEndColor(this.control.readColor3f(in));
    }

    @Override
    public void addSubReference() {
        this.control.getSymbolTable().incNodeComponentRefCount(this.target);
    }

    @Override
    public void buildGraph() {
        ((ColorInterpolator)this.node).setTarget((Material)this.control.getSymbolTable().getJ3dNode(this.target));
        super.buildGraph();
    }

    @Override
    public SceneGraphObject createNode(Class j3dClass) {
        return this.createNode(j3dClass, new Class[]{Alpha.class, Material.class}, new Object[]{null, null});
    }

    @Override
    protected SceneGraphObject createNode() {
        return new ColorInterpolator(null, null);
    }
}

