/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.LeafState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.AuralAttributes;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.Soundscape;

public class SoundscapeState
extends LeafState {
    private int boundingLeaf;
    private int auralAttributes;

    public SoundscapeState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        out.writeInt(this.control.getSymbolTable().addReference((SceneGraphObject)((Soundscape)this.node).getApplicationBoundingLeaf()));
        this.control.writeBounds(out, ((Soundscape)this.node).getApplicationBounds());
        out.writeInt(this.control.getSymbolTable().addReference((SceneGraphObject)((Soundscape)this.node).getAuralAttributes()));
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        this.boundingLeaf = in.readInt();
        ((Soundscape)this.node).setApplicationBounds(this.control.readBounds(in));
        this.auralAttributes = in.readInt();
    }

    public void addSubReference() {
        this.control.getSymbolTable().incNodeComponentRefCount(this.auralAttributes);
    }

    @Override
    public void buildGraph() {
        ((Soundscape)this.node).setApplicationBoundingLeaf((BoundingLeaf)this.control.getSymbolTable().getJ3dNode(this.boundingLeaf));
        ((Soundscape)this.node).setAuralAttributes((AuralAttributes)this.control.getSymbolTable().getJ3dNode(this.auralAttributes));
        super.buildGraph();
    }

    @Override
    protected SceneGraphObject createNode() {
        return new Soundscape();
    }
}

