/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.util.FloatArray;
import org.scijava.util.PrimitiveArray;
import org.scijava.util.PrimitiveArrayTest;

public class FloatArrayTest
extends PrimitiveArrayTest {
    @Test
    public void testConstructorNoArgs() {
        FloatArray array = new FloatArray();
        Assert.assertEquals((long)0L, (long)array.size());
        Assert.assertEquals((long)0L, (long)((float[])array.copyArray()).length);
    }

    @Test
    public void testConstructorSize() {
        int size = 24;
        FloatArray array = new FloatArray(24);
        Assert.assertEquals((long)24L, (long)array.size());
        Assert.assertEquals((long)24L, (long)((float[])array.copyArray()).length);
    }

    @Test
    public void testConstructorArray() {
        float[] raw = new float[]{3.0f, 5.0f, 8.0f, 13.0f, 21.0f};
        FloatArray array = new FloatArray(raw);
        Assert.assertSame((Object)raw, (Object)array.getArray());
        Assert.assertEquals((long)raw.length, (long)array.size());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (double)raw[i], (double)array.getValue(i), (double)0.0);
        }
        Assert.assertArrayEquals((float[])raw, (float[])((float[])array.copyArray()), (float)0.0f);
    }

    @Test
    public void testAddValue() {
        float[] raw = new float[]{3.0f, 5.0f, 8.0f, 13.0f, 21.0f};
        FloatArray array = new FloatArray((float[])raw.clone());
        float e6 = 1.1f;
        float e7 = 2.2f;
        array.addValue(1.1f);
        array.addValue(2.2f);
        Assert.assertEquals((long)(raw.length + 2), (long)array.size());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (double)raw[i], (double)array.getValue(i), (double)0.0);
        }
        Assert.assertEquals((double)1.1f, (double)array.getValue(5), (double)0.0);
        Assert.assertEquals((double)2.2f, (double)array.getValue(6), (double)0.0);
    }

    public void testRemoveValue() {
        float[] raw = new float[]{3.0f, 5.0f, 8.0f, 13.0f, 21.0f};
        FloatArray array = new FloatArray((float[])raw.clone());
        Assert.assertEquals((long)raw.length, (long)array.size());
        array.removeValue(raw[0]);
        Assert.assertEquals((long)(raw.length - 1), (long)array.size());
        array.removeValue(raw[2]);
        Assert.assertEquals((long)(raw.length - 2), (long)array.size());
        array.removeValue(raw[4]);
        Assert.assertEquals((long)(raw.length - 3), (long)array.size());
        Assert.assertEquals((double)raw[1], (double)array.getValue(0), (double)0.0);
        Assert.assertEquals((double)raw[3], (double)array.getValue(1), (double)0.0);
    }

    public void testGetValue() {
        float[] raw = new float[]{3.0f, 5.0f, 8.0f, 13.0f, 21.0f};
        FloatArray array = new FloatArray((float[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (double)raw[i], (double)array.getValue(i), (double)0.0);
        }
    }

    @Test
    public void testSetValue() {
        float[] raw = new float[]{3.0f, 5.0f, 8.0f, 13.0f, 21.0f};
        FloatArray array = new FloatArray((float[])raw.clone());
        float e0 = 7.7f;
        float e2 = 1.1f;
        float e4 = 2.2f;
        array.setValue(0, 7.7f);
        array.setValue(2, 1.1f);
        array.setValue(4, 2.2f);
        Assert.assertEquals((long)raw.length, (long)array.size());
        Assert.assertEquals((double)7.7f, (double)array.getValue(0), (double)0.0);
        Assert.assertEquals((double)raw[1], (double)array.getValue(1), (double)0.0);
        Assert.assertEquals((double)1.1f, (double)array.getValue(2), (double)0.0);
        Assert.assertEquals((double)raw[3], (double)array.getValue(3), (double)0.0);
        Assert.assertEquals((double)2.2f, (double)array.getValue(4), (double)0.0);
    }

    @Test
    public void testAddValueIndex() {
        float[] raw = new float[]{3.0f, 5.0f, 8.0f, 13.0f, 21.0f};
        FloatArray array = new FloatArray((float[])raw.clone());
        float e0 = 7.7f;
        float e4 = 1.1f;
        float e7 = 2.2f;
        array.addValue(0, 7.7f);
        array.addValue(4, 1.1f);
        array.addValue(7, 2.2f);
        Assert.assertEquals((long)(raw.length + 3), (long)array.size());
        Assert.assertEquals((double)7.7f, (double)array.getValue(0), (double)0.0);
        Assert.assertEquals((double)raw[0], (double)array.getValue(1), (double)0.0);
        Assert.assertEquals((double)raw[1], (double)array.getValue(2), (double)0.0);
        Assert.assertEquals((double)raw[2], (double)array.getValue(3), (double)0.0);
        Assert.assertEquals((double)1.1f, (double)array.getValue(4), (double)0.0);
        Assert.assertEquals((double)raw[3], (double)array.getValue(5), (double)0.0);
        Assert.assertEquals((double)raw[4], (double)array.getValue(6), (double)0.0);
        Assert.assertEquals((double)2.2f, (double)array.getValue(7), (double)0.0);
    }

    public void testRemoveIndex() {
        float[] raw = new float[]{3.0f, 5.0f, 8.0f, 13.0f, 21.0f};
        FloatArray array = new FloatArray((float[])raw.clone());
        Assert.assertEquals((long)raw.length, (long)array.size());
        array.remove(0);
        Assert.assertEquals((long)(raw.length - 1), (long)array.size());
        array.remove(2);
        Assert.assertEquals((long)(raw.length - 2), (long)array.size());
        array.remove(4);
        Assert.assertEquals((long)(raw.length - 3), (long)array.size());
        Assert.assertEquals((double)raw[1], (double)array.getValue(0), (double)0.0);
        Assert.assertEquals((double)raw[3], (double)array.getValue(1), (double)0.0);
    }

    @Test
    public void testIndexOf() {
        float[] raw = new float[]{3.0f, 5.0f, 8.0f, 13.0f, 21.0f};
        FloatArray array = new FloatArray((float[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)i, (long)array.indexOf(raw[i]));
        }
        Assert.assertEquals((long)-1L, (long)array.indexOf(-1.0f));
        Assert.assertEquals((long)-1L, (long)array.indexOf(0.0f));
        Assert.assertEquals((long)-1L, (long)array.indexOf(1.0f));
        Assert.assertEquals((long)-1L, (long)array.indexOf(Float.NaN));
        Assert.assertEquals((long)-1L, (long)array.indexOf(Float.POSITIVE_INFINITY));
        Assert.assertEquals((long)-1L, (long)array.indexOf(Float.NEGATIVE_INFINITY));
    }

    @Test
    public void testLastIndexOf() {
        float[] raw = new float[]{3.0f, 5.0f, 8.0f, 13.0f, 21.0f};
        FloatArray array = new FloatArray((float[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)i, (long)array.lastIndexOf(raw[i]));
        }
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf(-1.0f));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf(0.0f));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf(1.0f));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf(Float.NaN));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf(Float.POSITIVE_INFINITY));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf(Float.NEGATIVE_INFINITY));
    }

    @Test
    public void testContains() {
        float[] raw = new float[]{3.0f, 5.0f, 8.0f, 13.0f, 21.0f};
        FloatArray array = new FloatArray((float[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertTrue((String)("@" + i), (boolean)array.contains(raw[i]));
        }
        Assert.assertFalse((boolean)array.contains(-1.0f));
        Assert.assertFalse((boolean)array.contains(0.0f));
        Assert.assertFalse((boolean)array.contains(1.0f));
        Assert.assertFalse((boolean)array.contains(Float.NaN));
        Assert.assertFalse((boolean)array.contains(Float.POSITIVE_INFINITY));
        Assert.assertFalse((boolean)array.contains(Float.NEGATIVE_INFINITY));
    }

    @Test
    public void testSetArray() {
        FloatArray array = new FloatArray();
        float[] raw = new float[]{1.0f, 2.0f, 3.0f, 5.0f, 8.0f, 13.0f, 21.0f};
        array.setArray(raw);
        Assert.assertSame((Object)raw, (Object)array.getArray());
    }

    @Test
    public void testInsert() {
        float[] raw = new float[]{3.0f, 5.0f, 8.0f, 13.0f, 21.0f};
        this.testInsert((PrimitiveArray<?, ?>)new FloatArray(raw));
    }

    @Test
    public void testDelete() {
        float[] raw = new float[]{3.0f, 5.0f, 8.0f, 13.0f, 21.0f};
        this.testDelete((PrimitiveArray<?, ?>)new FloatArray(raw));
    }

    @Test
    public void testGet() {
        float[] raw = new float[]{3.0f, 5.0f, 8.0f, 13.0f, 21.0f};
        FloatArray array = new FloatArray((float[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (double)raw[i], (double)array.get(i).floatValue(), (double)0.0);
        }
    }

    @Test
    public void testSet() {
        float[] raw = new float[]{3.0f, 5.0f, 8.0f, 13.0f, 21.0f};
        FloatArray array = new FloatArray((float[])raw.clone());
        Float e0 = Float.valueOf(7.7f);
        Float e2 = Float.valueOf(1.1f);
        Float e4 = Float.valueOf(2.2f);
        array.set(0, e0);
        array.set(2, e2);
        array.set(4, e4);
        Assert.assertEquals((long)raw.length, (long)array.size());
        Assert.assertEquals((double)e0.floatValue(), (double)array.get(0).floatValue(), (double)0.0);
        Assert.assertEquals((double)raw[1], (double)array.getValue(1), (double)0.0);
        Assert.assertEquals((double)e2.floatValue(), (double)array.get(2).floatValue(), (double)0.0);
        Assert.assertEquals((double)raw[3], (double)array.getValue(3), (double)0.0);
        Assert.assertEquals((double)e4.floatValue(), (double)array.get(4).floatValue(), (double)0.0);
    }

    @Test
    public void testAdd() {
        float[] raw = new float[]{3.0f, 5.0f, 8.0f, 13.0f, 21.0f};
        FloatArray array = new FloatArray((float[])raw.clone());
        Float e6 = Float.valueOf(1.1f);
        Float e7 = Float.valueOf(2.2f);
        array.add((Object)e6);
        array.add((Object)e7);
        Assert.assertEquals((long)(raw.length + 2), (long)array.size());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (double)raw[i], (double)array.getValue(i), (double)0.0);
        }
        Assert.assertEquals((double)e6.floatValue(), (double)array.get(5).floatValue(), (double)0.0);
        Assert.assertEquals((double)e7.floatValue(), (double)array.get(6).floatValue(), (double)0.0);
    }

    @Test
    public void testIndexOfBoxed() {
        float[] raw = new float[]{3.0f, 5.0f, 8.0f, 13.0f, 21.0f};
        FloatArray array = new FloatArray((float[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)i, (long)array.indexOf((Object)new Float(raw[i])));
        }
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Float(-1.0f)));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Float(0.0f)));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Float(1.0f)));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Float(Float.NaN)));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Float(Float.POSITIVE_INFINITY)));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Float(Float.NEGATIVE_INFINITY)));
        Assert.assertEquals((long)-1L, (long)array.indexOf(null));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)"Not a float"));
    }

    @Test
    public void testLastIndexOfBoxed() {
        float[] raw = new float[]{3.0f, 5.0f, 8.0f, 13.0f, 21.0f};
        FloatArray array = new FloatArray((float[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)i, (long)array.lastIndexOf((Object)new Float(raw[i])));
        }
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Float(-1.0f)));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Float(0.0f)));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Float(1.0f)));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Float(Float.NaN)));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Float(Float.POSITIVE_INFINITY)));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Float(Float.NEGATIVE_INFINITY)));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf(null));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)"Not a float"));
    }

    @Test
    public void testContainsBoxed() {
        float[] raw = new float[]{3.0f, 5.0f, 8.0f, 13.0f, 21.0f};
        FloatArray array = new FloatArray((float[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertTrue((String)("@" + i), (boolean)array.contains((Object)new Float(raw[i])));
        }
        Assert.assertFalse((boolean)array.contains((Object)new Float(-1.0f)));
        Assert.assertFalse((boolean)array.contains((Object)new Float(0.0f)));
        Assert.assertFalse((boolean)array.contains((Object)new Float(1.0f)));
        Assert.assertFalse((boolean)array.contains((Object)new Float(Float.NaN)));
        Assert.assertFalse((boolean)array.contains((Object)new Float(Float.POSITIVE_INFINITY)));
        Assert.assertFalse((boolean)array.contains((Object)new Float(Float.NEGATIVE_INFINITY)));
        Assert.assertFalse((boolean)array.contains(null));
        Assert.assertFalse((boolean)array.contains((Object)"Not a float"));
    }

    @Test
    public void testRemove() {
        float[] raw = new float[]{3.0f, 5.0f, 8.0f, 13.0f, 21.0f};
        FloatArray array = new FloatArray((float[])raw.clone());
        Assert.assertEquals((long)raw.length, (long)array.size());
        array.remove((Object)new Float(raw[0]));
        Assert.assertEquals((long)(raw.length - 1), (long)array.size());
        array.remove((Object)new Float(raw[2]));
        Assert.assertEquals((long)(raw.length - 2), (long)array.size());
        array.remove((Object)new Float(raw[4]));
        Assert.assertEquals((long)(raw.length - 3), (long)array.size());
        Assert.assertEquals((double)raw[1], (double)array.getValue(0), (double)0.0);
        Assert.assertEquals((double)raw[3], (double)array.getValue(1), (double)0.0);
    }

    @Test
    public void testContainsAll() {
        float[] raw = new float[]{3.0f, 5.0f, 8.0f, 13.0f, 21.0f};
        FloatArray array = new FloatArray((float[])raw.clone());
        ArrayList<Float> list = new ArrayList<Float>();
        Assert.assertTrue((boolean)array.containsAll(list));
        list.add(Float.valueOf(13.0f));
        Assert.assertTrue((boolean)array.containsAll(list));
        list.add(Float.valueOf(1.0f));
        Assert.assertFalse((boolean)array.containsAll(list));
        FloatArray yes = new FloatArray(new float[]{3.0f, 8.0f, 21.0f});
        Assert.assertTrue((boolean)array.containsAll((Collection)yes));
        FloatArray no = new FloatArray(new float[]{5.0f, 13.0f, 1.0f});
        Assert.assertFalse((boolean)array.containsAll((Collection)no));
    }

    @Test
    public void testAddAll() {
        int i;
        float[] raw = new float[]{3.0f, 5.0f, 8.0f, 13.0f, 21.0f};
        FloatArray array = new FloatArray((float[])raw.clone());
        float[] add = new float[]{1.1f, 7.7f};
        FloatArray toAdd = new FloatArray((float[])add.clone());
        int index = 3;
        array.addAll(3, (Collection)toAdd);
        for (i = 0; i < 3; ++i) {
            Assert.assertEquals((double)raw[i], (double)array.getValue(i), (double)0.0);
        }
        for (i = 3; i < 3 + add.length; ++i) {
            Assert.assertEquals((double)add[i - 3], (double)array.getValue(i), (double)0.0);
        }
        for (i = 3 + add.length; i < raw.length + add.length; ++i) {
            Assert.assertEquals((double)raw[i - add.length], (double)array.getValue(i), (double)0.0);
        }
    }

    @Test
    public void testRemoveAll() {
        float[] raw = new float[]{3.0f, 5.0f, 8.0f, 13.0f, 21.0f};
        FloatArray array = new FloatArray((float[])raw.clone());
        FloatArray toRemove = new FloatArray(new float[]{3.0f, 8.0f, 21.0f});
        Assert.assertEquals((long)raw.length, (long)array.size());
        array.removeAll((Collection)toRemove);
        Assert.assertEquals((long)(raw.length - 3), (long)array.size());
        Assert.assertEquals((double)raw[1], (double)array.getValue(0), (double)0.0);
        Assert.assertEquals((double)raw[3], (double)array.getValue(1), (double)0.0);
    }
}

