/*
 * Decompiled with CFR 0.152.
 */
package org.scijava;

import org.junit.Assert;
import org.junit.Test;
import org.scijava.AbstractContextual;
import org.scijava.Context;
import org.scijava.event.EventHandler;
import org.scijava.event.EventService;
import org.scijava.event.SciJavaEvent;
import org.scijava.plugin.Parameter;
import org.scijava.service.AbstractService;

public class ContextInjectionTest {
    @Test
    public void testAbstractContextualSetContext() {
        Context context = new Context(new Class[]{FooService.class});
        NeedsFooContextual needsFoo = new NeedsFooContextual();
        Assert.assertNull((Object)((Object)needsFoo.fooService));
        needsFoo.setContext(context);
        Assert.assertSame((Object)context, (Object)needsFoo.getContext());
        Assert.assertSame((Object)context.getService(FooService.class), (Object)((Object)needsFoo.fooService));
    }

    @Test
    public void testAbstractContextualContextInject() {
        Context context = new Context(new Class[]{FooService.class});
        NeedsFooContextual needsFoo = new NeedsFooContextual();
        Assert.assertNull((Object)((Object)needsFoo.fooService));
        context.inject((Object)needsFoo);
        Assert.assertSame((Object)context, (Object)needsFoo.getContext());
        Assert.assertSame((Object)context.getService(FooService.class), (Object)((Object)needsFoo.fooService));
    }

    @Test
    public void testNonContextualServiceParameters() {
        Context context = new Context(new Class[]{FooService.class});
        NeedsFooPlain needsFoo = new NeedsFooPlain();
        Assert.assertNull((Object)((Object)needsFoo.fooService));
        context.inject((Object)needsFoo);
        Assert.assertSame((Object)context.getService(FooService.class), (Object)((Object)needsFoo.fooService));
    }

    @Test
    public void testNonContextualContextParameters() {
        Context context = new Context(true);
        NeedsContext needsContext = new NeedsContext();
        Assert.assertNull((Object)needsContext.context);
        context.inject((Object)needsContext);
        Assert.assertSame((Object)context, (Object)needsContext.context);
        try {
            context.inject((Object)needsContext);
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException exc) {
            String expectedMessage = "Context already injected: " + needsContext.getClass().getName() + "#context";
            Assert.assertEquals((Object)expectedMessage, (Object)exc.getMessage());
        }
    }

    @Test
    public void testAbstractContextualEventSubscription() {
        Context context = new Context(new Class[]{EventService.class});
        EventService eventService = (EventService)context.getService(EventService.class);
        HasEventsContextual hasEvents = new HasEventsContextual();
        Assert.assertFalse((boolean)hasEvents.eventReceived);
        eventService.publish(new SciJavaEvent(){});
        Assert.assertFalse((boolean)hasEvents.eventReceived);
        hasEvents.setContext(context);
        eventService.publish(new SciJavaEvent(){});
        Assert.assertTrue((boolean)hasEvents.eventReceived);
    }

    @Test
    public void testNonContextualEventSubscription() {
        Context context = new Context(new Class[]{EventService.class});
        EventService eventService = (EventService)context.getService(EventService.class);
        HasEventsPlain hasEvents = new HasEventsPlain();
        Assert.assertFalse((boolean)hasEvents.eventReceived);
        eventService.publish(new SciJavaEvent(){});
        Assert.assertFalse((boolean)hasEvents.eventReceived);
        context.inject((Object)hasEvents);
        eventService.publish(new SciJavaEvent(){});
        Assert.assertTrue((boolean)hasEvents.eventReceived);
    }

    public static class HasEventsPlain {
        private boolean eventReceived;

        @EventHandler
        private void onEvent(SciJavaEvent e) {
            this.eventReceived = true;
        }
    }

    public static class HasEventsContextual
    extends AbstractContextual {
        private boolean eventReceived;

        @EventHandler
        private void onEvent(SciJavaEvent e) {
            this.eventReceived = true;
        }
    }

    public static class NeedsContext {
        @Parameter
        private Context context;
    }

    public static class NeedsFooPlain {
        @Parameter
        private FooService fooService;
    }

    public static class NeedsFooContextual
    extends AbstractContextual {
        @Parameter
        private FooService fooService;
    }

    public static class FooService
    extends AbstractService {
    }
}

