/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.annotations;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import org.scijava.annotations.AbstractIndexWriter;
import org.scijava.annotations.ByteCodeAnalyzer;
import org.scijava.annotations.Indexable;

public class DirectoryIndexer
extends AbstractIndexWriter {
    public void index(File directory) throws IOException {
        try {
            URLClassLoader loader = new URLClassLoader(new URL[]{directory.toURL()}, Thread.currentThread().getContextClassLoader());
            this.discoverAnnotations(directory, "", loader);
        }
        catch (MalformedURLException e) {
            throw new IOException(e);
        }
        this.write(directory);
    }

    protected void discoverAnnotations(File directory, String classNamePrefix, ClassLoader loader) throws IOException {
        File[] list = directory.listFiles();
        if (list == null) {
            return;
        }
        for (File file : list) {
            String fileName;
            if (file.isDirectory()) {
                this.discoverAnnotations(file, classNamePrefix + file.getName() + ".", loader);
                continue;
            }
            if (!file.isFile() || !(fileName = file.getName()).endsWith(".class")) continue;
            String className = classNamePrefix + fileName.substring(0, fileName.length() - 6);
            try {
                for (Map.Entry<String, Map<String, Object>> entry : ByteCodeAnalyzer.getAnnotations(file).entrySet()) {
                    String annotationName;
                    block9: {
                        annotationName = entry.getKey();
                        try {
                            if (!DirectoryIndexer.isIndexable(loader.loadClass(annotationName))) {
                            }
                            break block9;
                        }
                        catch (ClassNotFoundException e) {
                            if (DirectoryIndexer.isIndexable(Class.forName(annotationName))) break block9;
                        }
                        continue;
                    }
                    this.add(entry.getValue(), annotationName, className);
                }
            }
            catch (Throwable e) {
                System.err.println("Warning: could not load class '" + className + "'; skipping");
                e.printStackTrace();
            }
        }
    }

    protected synchronized <A extends Annotation> void add(A annotation, String className) {
        if (!DirectoryIndexer.isIndexable(annotation)) {
            return;
        }
        this.add(this.adapt(annotation), annotation.annotationType().getName(), className);
    }

    private static <A extends Annotation> boolean isIndexable(A annotation) {
        return DirectoryIndexer.isIndexable(annotation.annotationType());
    }

    private static boolean isIndexable(Class<?> annotationClass) {
        return annotationClass.getAnnotation(Indexable.class) != null;
    }

    protected synchronized void write(final File directory) throws IOException {
        AbstractIndexWriter.StreamFactory factory = new AbstractIndexWriter.StreamFactory(){

            @Override
            public InputStream openInput(String annotationName) throws IOException {
                File file = new File(directory, "META-INF/json/" + annotationName);
                if (file.exists()) {
                    return new FileInputStream(file);
                }
                return null;
            }

            @Override
            public OutputStream openOutput(String annotationName) throws IOException {
                final File file = new File(directory, "META-INF/json/" + annotationName);
                File directory2 = file.getParentFile();
                if (directory2 != null && !directory2.isDirectory() && !directory2.mkdirs()) {
                    throw new IOException("Could not make directory " + directory2);
                }
                return new FileOutputStream(file){

                    @Override
                    public void close() throws IOException {
                        super.close();
                        if (file.length() == 0L) {
                            file.delete();
                        }
                    }
                };
            }

            @Override
            public boolean isClassObsolete(String className) {
                String classPath = className.replace('.', '/') + ".class";
                return !new File(directory, classPath).exists();
            }
        };
        File[] possiblyObsoletes = new File(directory, "META-INF/json/").listFiles();
        if (possiblyObsoletes != null) {
            for (File candidate : possiblyObsoletes) {
                if (!candidate.isFile()) continue;
                String annotationName = candidate.getName();
                this.merge(annotationName, factory);
            }
        }
        this.write(factory);
    }
}

