/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.scijava.log.LogService;
import org.scijava.object.LazyObjects;
import org.scijava.object.ObjectService;
import org.scijava.plugin.AbstractPTService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.SingletonPlugin;
import org.scijava.plugin.SingletonService;

public abstract class AbstractSingletonService<PT extends SingletonPlugin>
extends AbstractPTService<PT>
implements SingletonService<PT> {
    @Parameter
    private LogService log;
    @Parameter
    private ObjectService objectService;
    private List<PT> instances;
    private Map<Class<? extends PT>, PT> instanceMap;

    @Override
    public List<PT> getInstances() {
        if (this.instances == null) {
            this.initInstances();
        }
        return this.instances;
    }

    @Override
    public <P extends PT> P getInstance(Class<P> pluginClass) {
        if (this.instanceMap == null) {
            this.initInstances();
        }
        return (P)((SingletonPlugin)this.instanceMap.get(pluginClass));
    }

    @Override
    public void initialize() {
        this.objectService.getIndex().addLater(new LazyObjects<Object>(){

            @Override
            public ArrayList<Object> get() {
                return new ArrayList<Object>(AbstractSingletonService.this.getInstances());
            }
        });
    }

    protected List<? extends PT> filterInstances(List<PT> list) {
        return list;
    }

    private synchronized void initInstances() {
        if (this.instances != null) {
            return;
        }
        this.instances = Collections.unmodifiableList(this.filterInstances(this.getPluginService().createInstancesOfType(this.getPluginType())));
        this.instanceMap = new HashMap<Class<? extends PT>, PT>();
        for (SingletonPlugin plugin : this.instances) {
            Class<?> ptClass = plugin.getClass();
            this.instanceMap.put(ptClass, plugin);
        }
        this.log.info("Found " + this.instances.size() + " " + this.getPluginType().getSimpleName() + " plugins.");
    }
}

