/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.widget;

import java.util.ArrayList;
import java.util.List;
import org.scijava.AbstractContextual;
import org.scijava.convert.ConvertService;
import org.scijava.module.Module;
import org.scijava.module.ModuleCanceledException;
import org.scijava.module.ModuleException;
import org.scijava.module.ModuleItem;
import org.scijava.object.ObjectService;
import org.scijava.plugin.Parameter;
import org.scijava.widget.InputHarvester;
import org.scijava.widget.InputPanel;
import org.scijava.widget.InputWidget;
import org.scijava.widget.WidgetModel;
import org.scijava.widget.WidgetService;

public abstract class AbstractInputHarvester<P, W>
extends AbstractContextual
implements InputHarvester<P, W> {
    @Parameter
    private WidgetService widgetService;
    @Parameter
    private ObjectService objectService;
    @Parameter
    private ConvertService convertService;

    @Override
    public void harvest(Module module) throws ModuleException {
        InputPanel inputPanel = this.createInputPanel();
        this.buildPanel(inputPanel, module);
        if (!inputPanel.hasWidgets()) {
            return;
        }
        boolean ok = this.harvestInputs(inputPanel, module);
        if (!ok) {
            throw new ModuleCanceledException();
        }
        this.processResults(inputPanel, module);
    }

    @Override
    public void buildPanel(InputPanel<P, W> inputPanel, Module module) throws ModuleException {
        Iterable<ModuleItem<?>> inputs = module.getInfo().inputs();
        ArrayList<WidgetModel> models = new ArrayList<WidgetModel>();
        for (ModuleItem<?> item : inputs) {
            WidgetModel model = this.addInput(inputPanel, module, item);
            if (model == null) continue;
            models.add(model);
        }
        for (WidgetModel model : models) {
            model.setInitialized(true);
        }
        module.preview();
    }

    @Override
    public void processResults(InputPanel<P, W> inputPanel, Module module) throws ModuleException {
        Iterable<ModuleItem<?>> inputs = module.getInfo().inputs();
        for (ModuleItem<?> item : inputs) {
            String name = item.getName();
            module.setResolved(name, true);
        }
    }

    private <T> WidgetModel addInput(InputPanel<P, W> inputPanel, Module module, ModuleItem<T> item) throws ModuleException {
        String name = item.getName();
        boolean resolved = module.isResolved(name);
        if (resolved) {
            return null;
        }
        Class<T> type = item.getType();
        WidgetModel model = new WidgetModel(this.getContext(), inputPanel, module, item, this.getObjects(type));
        Class<W> widgetType = inputPanel.getWidgetComponentType();
        InputWidget<?, ?> widget = this.widgetService.create(model);
        if (widget != null && widget.getComponentType() == widgetType) {
            InputWidget<?, ?> typedWidget = widget;
            inputPanel.addWidget(typedWidget);
            return model;
        }
        if (item.isRequired()) {
            throw new ModuleException("A " + type.getSimpleName() + " is required but none exist.");
        }
        return null;
    }

    private List<?> getObjects(Class<?> type) {
        ArrayList<Object> compatibleInputs = new ArrayList<Object>(this.convertService.getCompatibleInputs(type));
        compatibleInputs.addAll(this.objectService.getObjects(type));
        return compatibleInputs;
    }
}

