/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.test.TestUtils;
import org.scijava.util.ClassUtils;
import org.scijava.util.FileUtils;

public class ClassUtilsTest {
    @Test
    public void testLoadClass() {
        this.assertLoaded(Boolean.TYPE, "boolean");
        this.assertLoaded(Byte.TYPE, "byte");
        this.assertLoaded(Character.TYPE, "char");
        this.assertLoaded(Double.TYPE, "double");
        this.assertLoaded(Float.TYPE, "float");
        this.assertLoaded(Integer.TYPE, "int");
        this.assertLoaded(Long.TYPE, "long");
        this.assertLoaded(Short.TYPE, "short");
        this.assertLoaded(Void.TYPE, "void");
        this.assertLoaded(String.class, "string");
        this.assertLoaded(Number.class, "java.lang.Number");
        this.assertLoaded(boolean[].class, "boolean[]");
        this.assertLoaded(byte[].class, "byte[]");
        this.assertLoaded(char[].class, "char[]");
        this.assertLoaded(double[].class, "double[]");
        this.assertLoaded(float[].class, "float[]");
        this.assertLoaded(int[].class, "int[]");
        this.assertLoaded(long[].class, "long[]");
        this.assertLoaded(short[].class, "short[]");
        this.assertLoaded(null, "void[]");
        this.assertLoaded(String[].class, "string[]");
        this.assertLoaded(Number[].class, "java.lang.Number[]");
        this.assertLoaded(boolean[][].class, "boolean[][]");
        this.assertLoaded(byte[][].class, "byte[][]");
        this.assertLoaded(char[][].class, "char[][]");
        this.assertLoaded(double[][].class, "double[][]");
        this.assertLoaded(float[][].class, "float[][]");
        this.assertLoaded(int[][].class, "int[][]");
        this.assertLoaded(long[][].class, "long[][]");
        this.assertLoaded(short[][].class, "short[][]");
        this.assertLoaded(null, "void[][]");
        this.assertLoaded(String[][].class, "string[][]");
        this.assertLoaded(Number[][].class, "java.lang.Number[][]");
        this.assertLoaded(boolean[].class, "[Z");
        this.assertLoaded(byte[].class, "[B");
        this.assertLoaded(char[].class, "[C");
        this.assertLoaded(double[].class, "[D");
        this.assertLoaded(float[].class, "[F");
        this.assertLoaded(int[].class, "[I");
        this.assertLoaded(long[].class, "[J");
        this.assertLoaded(short[].class, "[S");
        this.assertLoaded(null, "[V");
        this.assertLoaded(String[].class, "[Lstring;");
        this.assertLoaded(Number[].class, "[Ljava.lang.Number;");
        this.assertLoaded(boolean[][].class, "[[Z");
        this.assertLoaded(byte[][].class, "[[B");
        this.assertLoaded(char[][].class, "[[C");
        this.assertLoaded(double[][].class, "[[D");
        this.assertLoaded(float[][].class, "[[F");
        this.assertLoaded(int[][].class, "[[I");
        this.assertLoaded(long[][].class, "[[J");
        this.assertLoaded(short[][].class, "[[S");
        this.assertLoaded(null, "[[V");
        this.assertLoaded(String[][].class, "[[Lstring;");
        this.assertLoaded(Number[][].class, "[[Ljava.lang.Number;");
    }

    @Test
    public void testGetArrayClass() {
        Assert.assertSame(boolean[].class, (Object)ClassUtils.getArrayClass(Boolean.TYPE));
        Assert.assertSame(String[].class, (Object)ClassUtils.getArrayClass(String.class));
        Assert.assertSame(Number[].class, (Object)ClassUtils.getArrayClass(Number.class));
        Assert.assertSame(boolean[][].class, (Object)ClassUtils.getArrayClass(boolean[].class));
        Assert.assertSame(String[][].class, (Object)ClassUtils.getArrayClass(String[].class));
        Assert.assertSame(Number[][].class, (Object)ClassUtils.getArrayClass(Number[].class));
        Assert.assertNull((Object)ClassUtils.getArrayClass(Void.TYPE));
    }

    @Test
    public void testUnpackedClass() throws IOException {
        String path;
        File tmpDir = TestUtils.createTemporaryDirectory((String)"class-utils-test-");
        File classFile = new File(tmpDir, path = this.getClass().getName().replace('.', '/') + ".class");
        Assert.assertTrue((classFile.getParentFile().exists() || classFile.getParentFile().mkdirs() ? 1 : 0) != 0);
        this.copy(this.getClass().getResource("/" + path).openStream(), new FileOutputStream(classFile), true);
        URLClassLoader classLoader = new URLClassLoader(new URL[]{tmpDir.toURI().toURL()}, null);
        URL location = ClassUtils.getLocation((String)this.getClass().getName(), (ClassLoader)classLoader);
        Assert.assertEquals((Object)tmpDir, (Object)FileUtils.urlToFile((URL)location));
        FileUtils.deleteRecursively((File)tmpDir);
    }

    @Test
    public void testClassInJar() throws IOException {
        File tmpDir = TestUtils.createTemporaryDirectory((String)"class-utils-test-");
        File jar = new File(tmpDir, "test.jar");
        JarOutputStream out = new JarOutputStream(new FileOutputStream(jar));
        String path = this.getClass().getName().replace('.', '/') + ".class";
        out.putNextEntry(new ZipEntry(path));
        this.copy(this.getClass().getResource("/" + path).openStream(), out, true);
        URLClassLoader classLoader = new URLClassLoader(new URL[]{jar.toURI().toURL()}, null);
        URL location = ClassUtils.getLocation((String)this.getClass().getName(), (ClassLoader)classLoader);
        Assert.assertEquals((Object)jar, (Object)FileUtils.urlToFile((URL)location));
        jar.deleteOnExit();
    }

    private void copy(InputStream in, OutputStream out, boolean closeOut) throws IOException {
        int count;
        byte[] buffer = new byte[16384];
        while ((count = in.read(buffer)) >= 0) {
            out.write(buffer, 0, count);
        }
        in.close();
        if (closeOut) {
            out.close();
        }
    }

    private void assertLoaded(Class<?> c, String name) {
        Assert.assertSame(c, (Object)ClassUtils.loadClass((String)name));
    }
}

