/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.command;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.ItemIO;
import org.scijava.ValidityProblem;
import org.scijava.command.Command;
import org.scijava.command.CommandInfo;
import org.scijava.command.CommandService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

public class InvalidCommandTest {
    private CommandService commandService;

    @Before
    public void setUp() {
        Context ctx = new Context(new Class[]{CommandService.class});
        this.commandService = (CommandService)ctx.getService(CommandService.class);
    }

    @Test
    public void testValid() {
        CommandInfo info = this.commandService.getCommand(ValidCommand.class);
        Assert.assertNotNull((Object)info);
        Assert.assertTrue((boolean)info.isValid());
        List problems = info.getProblems();
        Assert.assertNotNull((Object)problems);
        Assert.assertEquals((long)0L, (long)problems.size());
    }

    @Test
    public void testInvalid() {
        CommandInfo info = this.commandService.getCommand(InvalidCommand.class);
        Assert.assertNotNull((Object)info);
        Assert.assertFalse((boolean)info.isValid());
        List problems = info.getProblems();
        Assert.assertNotNull((Object)problems);
        Assert.assertEquals((long)3L, (long)problems.size());
        String p0 = ((ValidityProblem)problems.get(0)).getMessage();
        Assert.assertEquals((Object)"Delegate class is abstract", (Object)p0);
        String p1 = ((ValidityProblem)problems.get(1)).getMessage();
        Assert.assertEquals((Object)"Invalid duplicate parameter: private int org.scijava.command.InvalidCommandTest$InvalidCommand.x", (Object)p1);
        String p2 = ((ValidityProblem)problems.get(2)).getMessage();
        Assert.assertEquals((Object)"Invalid final parameter: private final float org.scijava.command.InvalidCommandTest$InvalidCommand.y", (Object)p2);
    }

    @Plugin(type=Command.class)
    public static abstract class InvalidCommand
    extends ValidCommand {
        @Parameter
        private int x;
        @Parameter
        private final float y = 0.0f;
        @Parameter(type=ItemIO.OUTPUT)
        private String invalidOutput;

        @Override
        public void run() {
            this.invalidOutput = "InvalidCommand: FAILURE";
        }
    }

    @Plugin(type=Command.class)
    public static class ValidCommand
    implements Command {
        @Parameter
        private double x;
        @Parameter(type=ItemIO.OUTPUT)
        private String validOutput;

        public void run() {
            this.validOutput = "ValidCommand: success!";
        }
    }
}

