/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.convert;

import java.lang.reflect.Type;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.convert.AbstractConverter;
import org.scijava.convert.NullConverter;

public class ConverterTest {
    @Test
    public void testNullConverter() {
        NullConverter nc = new NullConverter();
        Assert.assertFalse((boolean)nc.canConvert(Object.class, Object.class));
        Assert.assertFalse((boolean)nc.canConvert(Object.class, Object.class));
        Assert.assertFalse((boolean)nc.canConvert((Class)null, Object.class));
        Assert.assertTrue((boolean)nc.canConvert((Object)null, Object.class));
        Assert.assertTrue((boolean)nc.canConvert((Object)null, ArrayList.class));
        Assert.assertNull((Object)nc.convert((Object)null, Object.class));
        Assert.assertNull((Object)nc.convert((Object)null, Object.class));
        Assert.assertNull((Object)nc.convert(Object.class, (Class)null));
        Assert.assertNull((Object)nc.convert(Object.class, (Type)null));
        Assert.assertNull((Object)nc.convert(new Object(), (Class)null));
        Assert.assertNull((Object)nc.convert(new Object(), (Type)null));
    }

    @Test
    public void testCanConvert() {
        NumberConverter nc = new NumberConverter();
        Assert.assertFalse((boolean)nc.canConvert(Integer.class, Double.class));
        Assert.assertTrue((boolean)nc.canConvert(Integer.class, Number.class));
    }

    private static class NumberConverter
    extends AbstractConverter<Number, Number> {
        private NumberConverter() {
        }

        public <T> T convert(Object src, Class<T> dest) {
            return (T)src;
        }

        public Class<Number> getOutputType() {
            return Number.class;
        }

        public Class<Number> getInputType() {
            return Number.class;
        }
    }
}

