/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.module;

import org.junit.Assert;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.module.AbstractModule;
import org.scijava.module.AbstractModuleInfo;
import org.scijava.module.AbstractModuleItem;
import org.scijava.module.Module;
import org.scijava.module.ModuleException;
import org.scijava.module.ModuleInfo;
import org.scijava.module.ModuleItem;
import org.scijava.module.ModuleService;

public class ModuleServiceTest {
    @Test
    public void testGetSingleInput() throws ModuleException {
        Context context = new Context(new Class[]{ModuleService.class});
        ModuleService moduleService = (ModuleService)context.getService(ModuleService.class);
        FooModuleInfo info = new FooModuleInfo();
        Module module = info.createModule();
        ModuleItem singleString = moduleService.getSingleInput(module, String.class);
        Assert.assertSame((Object)info.getInput("string"), (Object)singleString);
        ModuleItem singleFloat = moduleService.getSingleInput(module, Float.class);
        Assert.assertNull((Object)singleFloat);
        ModuleItem singleInteger = moduleService.getSingleInput(module, Integer.class);
        Assert.assertNull((Object)singleInteger);
        ModuleItem singleDouble = moduleService.getSingleInput(module, Double.class);
        Assert.assertSame((Object)info.getInput("double2"), (Object)singleDouble);
    }

    public static class FooModuleInfo
    extends AbstractModuleInfo {
        public String getDelegateClassName() {
            return FooModule.class.getName();
        }

        public Class<?> loadDelegateClass() throws ClassNotFoundException {
            return FooModule.class;
        }

        public Module createModule() throws ModuleException {
            return new FooModule(this);
        }

        protected void parseParameters() {
            this.addInput("string", String.class, true);
            this.addInput("float", Float.class, false);
            this.addInput("integer1", Integer.class, true);
            this.addInput("integer2", Integer.class, true);
            this.addInput("double1", Double.class, false);
            this.addInput("double2", Double.class, true);
        }

        private <T> void addInput(final String name, final Class<T> type, final boolean autoFill) {
            this.registerInput((ModuleItem)new AbstractModuleItem<T>((ModuleInfo)this){

                public String getName() {
                    return name;
                }

                public Class<T> getType() {
                    return type;
                }

                public boolean isAutoFill() {
                    return autoFill;
                }
            });
        }
    }

    public static class FooModule
    extends AbstractModule {
        private final FooModuleInfo info;

        public FooModule(FooModuleInfo info) {
            this.info = info;
        }

        public ModuleInfo getInfo() {
            return this.info;
        }

        public void run() {
        }
    }
}

