/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.menu;

import java.lang.reflect.Array;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.scijava.AbstractContextual;
import org.scijava.Context;
import org.scijava.MenuEntry;
import org.scijava.MenuPath;
import org.scijava.Named;
import org.scijava.event.EventService;
import org.scijava.log.LogService;
import org.scijava.menu.ShadowMenuIterator;
import org.scijava.menu.event.MenusAddedEvent;
import org.scijava.menu.event.MenusRemovedEvent;
import org.scijava.menu.event.MenusUpdatedEvent;
import org.scijava.module.ModuleInfo;
import org.scijava.module.ModuleService;
import org.scijava.plugin.Parameter;
import org.scijava.util.ClassUtils;
import org.scijava.util.MiscUtils;

public class ShadowMenu
extends AbstractContextual
implements Comparable<ShadowMenu>,
Collection<ModuleInfo>,
Runnable,
Named {
    private static final String DEFAULT_ICON_PATH = "/icons/plugin.png";
    private final ModuleInfo moduleInfo;
    private final MenuEntry menuEntry;
    private final int menuDepth;
    private final ShadowMenu parent;
    private final Map<String, ShadowMenu> children;
    @Parameter(required=false)
    private EventService es;
    @Parameter(required=false)
    private ModuleService moduleService;
    @Parameter(required=false)
    private LogService log;

    public ShadowMenu(Context context, Collection<? extends ModuleInfo> modules) {
        this(context, null, -1, null);
        this.addAll(modules);
    }

    private ShadowMenu(Context context, ModuleInfo moduleInfo, int menuDepth, ShadowMenu parent) {
        this.setContext(context);
        if (moduleInfo == null) {
            this.moduleInfo = null;
            this.menuEntry = null;
        } else {
            MenuPath menuPath = moduleInfo.getMenuPath();
            boolean leaf = menuDepth == menuPath.size() - 1;
            this.moduleInfo = leaf ? moduleInfo : null;
            this.menuEntry = (MenuEntry)menuPath.get(menuDepth);
        }
        this.menuDepth = menuDepth;
        this.parent = parent;
        this.children = new HashMap<String, ShadowMenu>();
    }

    public ModuleInfo getModuleInfo() {
        return this.moduleInfo;
    }

    public ShadowMenu getMenu(MenuPath menuPath) {
        return this.getMenu(menuPath, 0);
    }

    public ShadowMenu getMenu(String path) {
        return this.getMenu(new MenuPath(path), 0);
    }

    public MenuEntry getMenuEntry() {
        return this.menuEntry;
    }

    public int getMenuDepth() {
        return this.menuDepth;
    }

    public ShadowMenu getParent() {
        return this.parent;
    }

    public List<ShadowMenu> getChildren() {
        ArrayList<ShadowMenu> childList = new ArrayList<ShadowMenu>(this.children.values());
        Collections.sort(childList);
        return childList;
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public boolean isToggle() {
        if (this.moduleInfo == null) {
            return false;
        }
        return this.moduleInfo.isSelectable();
    }

    public boolean isCheckBox() {
        if (!this.isToggle()) {
            return false;
        }
        String selectionGroup = this.moduleInfo.getSelectionGroup();
        return selectionGroup == null || selectionGroup.isEmpty();
    }

    public boolean isRadioButton() {
        if (!this.isToggle()) {
            return false;
        }
        String selectionGroup = this.moduleInfo.getSelectionGroup();
        return selectionGroup != null && !selectionGroup.isEmpty();
    }

    public URL getIconURL() {
        String className;
        Class<?> c;
        if (this.menuEntry == null) {
            return null;
        }
        String iconPath = this.menuEntry.getIconPath();
        if (iconPath == null || iconPath.isEmpty()) {
            if (this.isLeaf()) {
                iconPath = DEFAULT_ICON_PATH;
            } else {
                return null;
            }
        }
        if ((c = ClassUtils.loadClass(className = this.moduleInfo.getDelegateClassName())) == null) {
            return null;
        }
        URL iconURL = c.getResource(iconPath);
        if (iconURL == null && this.log != null) {
            this.log.error("Could not load icon: " + iconPath);
        }
        return iconURL;
    }

    public boolean update(ModuleInfo module) {
        ShadowMenu removed = this.removeInternal(module);
        if (removed == null) {
            return false;
        }
        ShadowMenu node = this.addInternal(module);
        if (node == null) {
            return false;
        }
        if (this.es != null) {
            this.es.publish(new MenusUpdatedEvent(node));
        }
        return true;
    }

    public boolean updateAll(Collection<? extends ModuleInfo> c) {
        HashSet<ShadowMenu> nodes = new HashSet<ShadowMenu>();
        for (ModuleInfo moduleInfo : c) {
            ShadowMenu node;
            ShadowMenu removed = this.removeInternal(moduleInfo);
            if (removed == null || (node = this.addInternal(moduleInfo)) == null) continue;
            nodes.add(node);
        }
        if (nodes.isEmpty()) {
            return false;
        }
        if (this.es != null) {
            this.es.publish(new MenusUpdatedEvent((Collection<? extends ShadowMenu>)nodes));
        }
        return true;
    }

    @Override
    public String getName() {
        return this.menuEntry == null ? null : this.menuEntry.getName();
    }

    @Override
    public void setName(String name) {
        if (this.menuEntry == null) {
            return;
        }
        this.menuEntry.setName(name);
    }

    @Override
    public int compareTo(ShadowMenu c) {
        double w2;
        if (this.menuEntry == null || c.menuEntry == null) {
            return 0;
        }
        double w1 = this.menuEntry.getWeight();
        if (w1 < (w2 = c.menuEntry.getWeight())) {
            return -1;
        }
        if (w1 > w2) {
            return 1;
        }
        String n1 = this.menuEntry.getName();
        String n2 = c.menuEntry.getName();
        return MiscUtils.compare(n1, n2);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i <= this.menuDepth; ++i) {
            sb.append("\t");
        }
        String name = this.getName();
        sb.append(name == null ? "[-]" : name);
        for (ShadowMenu child : this.getChildren()) {
            sb.append("\n" + child.toString());
        }
        return sb.toString();
    }

    @Override
    public void run() {
        if (this.moduleInfo == null) {
            return;
        }
        if (this.moduleService != null) {
            this.moduleService.run(this.moduleInfo, true, new Object[0]);
        }
    }

    @Override
    public boolean add(ModuleInfo o) {
        if (!o.isVisible()) {
            return false;
        }
        ShadowMenu node = this.addInternal(o);
        if (node == null) {
            return false;
        }
        if (this.es != null) {
            this.es.publish(new MenusAddedEvent(node));
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends ModuleInfo> c) {
        HashSet<ShadowMenu> nodes = new HashSet<ShadowMenu>();
        for (ModuleInfo moduleInfo : c) {
            ShadowMenu node;
            if (!moduleInfo.isVisible() || (node = this.addInternal(moduleInfo)) == null) continue;
            nodes.add(node);
        }
        if (nodes.isEmpty()) {
            return false;
        }
        if (this.es != null) {
            this.es.publish(new MenusAddedEvent((Collection<? extends ShadowMenu>)nodes));
        }
        return true;
    }

    @Override
    public void clear() {
        this.children.clear();
    }

    @Override
    public boolean contains(Object o) {
        if (o == this.moduleInfo) {
            return true;
        }
        for (ShadowMenu node : this.children.values()) {
            if (!node.contains(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    public ShadowMenuIterator iterator() {
        return new ShadowMenuIterator(this);
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof ModuleInfo)) {
            return false;
        }
        ModuleInfo info = (ModuleInfo)o;
        ShadowMenu node = this.removeInternal(info);
        if (node == null) {
            return false;
        }
        if (this.es != null) {
            this.es.publish(new MenusRemovedEvent(node));
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        HashSet<ShadowMenu> nodes = new HashSet<ShadowMenu>();
        for (Object o : c) {
            ModuleInfo info;
            ShadowMenu node;
            if (!(o instanceof ModuleInfo) || (node = this.removeInternal(info = (ModuleInfo)o)) == null) continue;
            nodes.add(node);
        }
        if (nodes.isEmpty()) {
            return false;
        }
        if (this.es != null) {
            this.es.publish(new MenusRemovedEvent((Collection<? extends ShadowMenu>)nodes));
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        ArrayList<ModuleInfo> toRemove = new ArrayList<ModuleInfo>();
        for (ModuleInfo info : this) {
            if (c.contains(info)) continue;
            toRemove.add(info);
        }
        return this.removeAll(toRemove);
    }

    @Override
    public int size() {
        int sum = this.moduleInfo == null ? 0 : 1;
        for (ShadowMenu child : this.children.values()) {
            sum += child.size();
        }
        return sum;
    }

    @Override
    public Object[] toArray() {
        Object[] a = new Object[this.size()];
        return this.toArray(a);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Object[] result;
        Class<?> componentType = a.getClass().getComponentType();
        if (!ModuleInfo.class.isAssignableFrom(componentType)) {
            throw new ArrayStoreException();
        }
        int size = this.size();
        if (a.length >= size) {
            result = a;
        } else {
            Object newArray = Array.newInstance(componentType, size);
            Object[] typedArray = (Object[])newArray;
            result = typedArray;
        }
        int index = 0;
        for (ModuleInfo element : this) {
            result[index++] = element;
        }
        return result;
    }

    private ShadowMenu addInternal(ModuleInfo o) {
        if (o.getMenuPath().isEmpty()) {
            return null;
        }
        return this.addChild(o, 0);
    }

    private ShadowMenu removeInternal(ModuleInfo o) {
        for (String menuName : this.children.keySet()) {
            ShadowMenu child = this.children.get(menuName);
            if (child.getModuleInfo() == o) {
                this.children.remove(menuName);
                return child;
            }
            ShadowMenu removed = child.removeInternal(o);
            if (removed == null) continue;
            if (child.isLeaf() && child.getModuleInfo() == null) {
                this.children.remove(menuName);
            }
            return removed;
        }
        return null;
    }

    private ShadowMenu addChild(ModuleInfo info, int depth) {
        ShadowMenu child;
        MenuPath menuPath = info.getMenuPath();
        MenuEntry entry = (MenuEntry)menuPath.get(depth);
        boolean leaf = this.isLeaf(depth, menuPath);
        ShadowMenu existingChild = this.children.get(entry.getName());
        if (existingChild == null) {
            String menuName = entry.getName();
            ShadowMenu newChild = new ShadowMenu(this.getContext(), info, depth, this);
            this.children.put(menuName, newChild);
            child = newChild;
        } else {
            MenuEntry childMenuEntry = existingChild.getMenuEntry();
            childMenuEntry.assignProperties(entry);
            child = existingChild;
        }
        if (!leaf) {
            child.addChild(info, depth + 1);
        } else if (existingChild != null && this.log != null) {
            ModuleInfo childInfo = existingChild.getModuleInfo();
            if (childInfo != null && info.getPriority() == childInfo.getPriority()) {
                this.log.warn("ShadowMenu: menu item already exists:\n\texisting: " + childInfo + "\n\t ignored: " + info);
            } else {
                this.log.debug("ShadowMenu: higher-priority menu item already exists:\n\texisting: " + childInfo + "\n\t ignored: " + info);
            }
        }
        return child;
    }

    private boolean isLeaf(int depth, MenuPath path) {
        return depth == path.size() - 1;
    }

    private ShadowMenu getMenu(MenuPath menuPath, int index) {
        MenuEntry entry = (MenuEntry)menuPath.get(index);
        for (ShadowMenu child : this.children.values()) {
            if (!entry.getName().equals(child.getMenuEntry().getName())) continue;
            if (this.isLeaf(index, menuPath)) {
                return child;
            }
            return child.getMenu(menuPath, index + 1);
        }
        return null;
    }
}

