/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.script;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.plugin.Plugin;
import org.scijava.script.AbstractScriptEngine;
import org.scijava.script.AbstractScriptLanguage;
import org.scijava.script.ScriptInfo;
import org.scijava.script.ScriptLanguage;
import org.scijava.script.ScriptModule;
import org.scijava.script.ScriptService;

public class ScriptEngineTest {
    @Test
    public void testRot13() throws Exception {
        Context context = new Context(new Class[]{ScriptService.class});
        ScriptService scriptService = (ScriptService)context.getService(ScriptService.class);
        ScriptLanguage hello = scriptService.getLanguageByName("Hello");
        Assert.assertNotNull((Object)hello);
        ScriptLanguage rot13 = scriptService.getLanguageByName("Rot13");
        Assert.assertEquals((Object)hello, (Object)rot13);
        Assert.assertEquals((Object)"Svool", (Object)rot13.getScriptEngine().eval("Hello"));
    }

    @Test
    public void testScriptModuleValue() throws Exception {
        Context context = new Context(new Class[]{ScriptService.class});
        ScriptService scriptService = (ScriptService)context.getService(ScriptService.class);
        ScriptModule module = (ScriptModule)scriptService.run("test.rot13", ScriptModule.class.getName(), false, (Map)null).get();
        ScriptModule scriptModule = Rot13Engine.latestModule;
        Assert.assertEquals((Object)module, (Object)scriptModule);
        Assert.assertNotNull((Object)scriptModule);
        ScriptInfo info = scriptModule.getInfo();
        Assert.assertEquals((Object)context, (Object)info.context());
    }

    private static class Rot13Bindings
    extends HashMap<String, Object>
    implements Bindings {
        private static final long serialVersionUID = 1L;

        private Rot13Bindings() {
        }
    }

    private static class Rot13Engine
    extends AbstractScriptEngine {
        private static ScriptModule latestModule;

        private Rot13Engine() {
            this.engineScopeBindings = new Rot13Bindings();
        }

        public Object eval(String script) throws ScriptException {
            return this.eval(new StringReader(script));
        }

        public Object eval(Reader reader) throws ScriptException {
            latestModule = (ScriptModule)this.get(ScriptModule.class.getName());
            StringBuilder builder = new StringBuilder();
            try {
                int c;
                while ((c = reader.read()) >= 0) {
                    if (c >= 65 && c <= 90) {
                        c = 90 - c + 65;
                    } else if (c >= 97 && c <= 122) {
                        c = 122 - c + 97;
                    }
                    builder.append((char)c);
                }
            }
            catch (IOException e) {
                throw new ScriptException(e);
            }
            return builder.toString();
        }
    }

    @Plugin(type=ScriptLanguage.class)
    public static class Rot13
    extends AbstractScriptLanguage {
        public ScriptEngine getScriptEngine() {
            return new Rot13Engine();
        }

        public List<String> getNames() {
            return Arrays.asList("Hello", "World", "Rot13");
        }

        public List<String> getExtensions() {
            return Arrays.asList("rot13");
        }
    }
}

