/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.util.Collection;
import java.util.Iterator;
import org.scijava.util.AbstractPrimitiveArray;

public class FloatArray
extends AbstractPrimitiveArray<float[], Float> {
    private float[] array;

    public FloatArray() {
        super(Float.TYPE);
    }

    public FloatArray(int size) {
        super(Float.TYPE, size);
    }

    public FloatArray(float[] array) {
        super(Float.TYPE, array);
    }

    public void addValue(float value) {
        this.addValue(this.size(), value);
    }

    public boolean removeValue(float value) {
        int index = this.indexOf(value);
        if (index < 0) {
            return false;
        }
        this.delete(index, 1);
        return true;
    }

    public float getValue(int index) {
        this.checkBounds(index);
        return this.array[index];
    }

    public float setValue(int index, float value) {
        this.checkBounds(index);
        float oldValue = this.getValue(index);
        this.array[index] = value;
        return oldValue;
    }

    public void addValue(int index, float value) {
        this.insert(index, 1);
        this.array[index] = value;
    }

    public int indexOf(float value) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(float value) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (this.array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(float value) {
        return this.indexOf(value) >= 0;
    }

    @Override
    public float[] getArray() {
        return this.array;
    }

    @Override
    public void setArray(float[] array) {
        if (array.length < this.size()) {
            throw new IllegalArgumentException("Array too small");
        }
        this.array = array;
    }

    @Override
    public Float get(int index) {
        return Float.valueOf(this.getValue(index));
    }

    @Override
    public Float set(int index, Float element) {
        return Float.valueOf(this.setValue(index, (element == null ? this.defaultValue() : element).floatValue()));
    }

    @Override
    public void add(int index, Float element) {
        this.addValue(index, element.floatValue());
    }

    @Override
    public int indexOf(Object o) {
        if (!(o instanceof Float)) {
            return -1;
        }
        float value = ((Float)o).floatValue();
        return this.indexOf(value);
    }

    @Override
    public int lastIndexOf(Object o) {
        if (!(o instanceof Float)) {
            return -1;
        }
        float value = ((Float)o).floatValue();
        return this.lastIndexOf(value);
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof Float)) {
            return false;
        }
        float value = ((Float)o).floatValue();
        return this.contains(value);
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Float)) {
            return false;
        }
        float value = ((Float)o).floatValue();
        return this.removeValue(value);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (!(o instanceof Float)) {
                return false;
            }
            float value = ((Float)o).floatValue();
            if (this.indexOf(value) >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Float> c) {
        if (c.size() == 0) {
            return false;
        }
        this.insert(index, c.size());
        int i = index;
        Iterator<? extends Float> i$ = c.iterator();
        while (i$.hasNext()) {
            float e = i$.next().floatValue();
            this.setValue(i++, e);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            float value;
            boolean result;
            if (!(o instanceof Float) || !(result = this.removeValue(value = ((Float)o).floatValue()))) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public Float defaultValue() {
        return Float.valueOf(0.0f);
    }
}

