/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.script;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.ItemIO;
import org.scijava.log.LogService;
import org.scijava.module.ModuleItem;
import org.scijava.plugin.Plugin;
import org.scijava.script.AbstractScriptEngine;
import org.scijava.script.AbstractScriptLanguage;
import org.scijava.script.ScriptInfo;
import org.scijava.script.ScriptLanguage;
import org.scijava.script.ScriptModule;
import org.scijava.script.ScriptService;
import org.scijava.test.TestUtils;
import org.scijava.util.DigestUtils;
import org.scijava.util.FileUtils;

public class ScriptInfoTest {
    private static Context context;
    private static ScriptService scriptService;

    @BeforeClass
    public static void setUp() {
        context = new Context();
        scriptService = (ScriptService)context.service(ScriptService.class);
    }

    @AfterClass
    public static void tearDown() {
        context.dispose();
    }

    @Test
    public void testNoisyParameters() throws Exception {
        String script = "% @LogService log\n% @OUTPUT Integer output% kraken@blah.net\n";
        ScriptModule scriptModule = (ScriptModule)scriptService.run("hello.bsizes", "% @LogService log\n% @OUTPUT Integer output% kraken@blah.net\n", true, new Object[0]).get();
        Object output = scriptModule.getOutput("result");
        if (output == null) {
            Assert.fail((String)"null result");
        } else if (!(output instanceof Integer)) {
            Assert.fail((String)("result is a " + output.getClass().getName()));
        } else {
            Assert.assertEquals((long)3L, (long)((Integer)output).intValue());
        }
    }

    @Test
    public void testVersion() throws IOException {
        String script = "% @LogService log\n% @OUTPUT int output";
        File tmpDir = TestUtils.createTemporaryDirectory((String)"script-info-test-");
        String path = "hello.bsizes";
        File scriptFile = new File(tmpDir, "hello.bsizes");
        FileUtils.writeFile((File)scriptFile, (byte[])DigestUtils.bytes((String)"% @LogService log\n% @OUTPUT int output"));
        ScriptInfo info = new ScriptInfo(context, scriptFile);
        String version = info.getVersion();
        String timestampPattern = "\\d{4}-\\d{2}-\\d{2}-\\d{2}:\\d{2}:\\d{2}";
        String sha1 = "28f4a2880d604774ac5d604d35f431047a087c9e";
        Assert.assertTrue((boolean)version.matches("^\\d{4}-\\d{2}-\\d{2}-\\d{2}:\\d{2}:\\d{2}-28f4a2880d604774ac5d604d35f431047a087c9e$"));
        FileUtils.deleteRecursively((File)tmpDir);
    }

    @Test
    public void testParameters() {
        String script = "% @LogService(required = false) log\n% @int(label=\"Slider Value\", softMin=5, softMax=15, stepSize=3, value=11, style=\"slider\") sliderValue\n% @BOTH java.lang.StringBuilder buffer";
        ScriptInfo info = new ScriptInfo(context, "params.bsizes", (Reader)new StringReader("% @LogService(required = false) log\n% @int(label=\"Slider Value\", softMin=5, softMax=15, stepSize=3, value=11, style=\"slider\") sliderValue\n% @BOTH java.lang.StringBuilder buffer"));
        ModuleItem log = info.getInput("log");
        this.assertItem("log", LogService.class, null, ItemIO.INPUT, false, true, null, null, null, null, null, null, null, null, log);
        ModuleItem sliderValue = info.getInput("sliderValue");
        this.assertItem("sliderValue", Integer.TYPE, "Slider Value", ItemIO.INPUT, true, true, null, "slider", 11, null, null, 5, 15, 3.0, sliderValue);
        ModuleItem buffer = info.getOutput("buffer");
        this.assertItem("buffer", StringBuilder.class, null, ItemIO.BOTH, true, true, null, null, null, null, null, null, null, null, buffer);
        ModuleItem result = info.getOutput("result");
        this.assertItem("result", Object.class, null, ItemIO.OUTPUT, true, true, null, null, null, null, null, null, null, null, result);
        int inputCount = 0;
        ModuleItem[] inputs = new ModuleItem[]{log, sliderValue, buffer};
        for (ModuleItem inItem : info.inputs()) {
            Assert.assertSame((Object)inputs[inputCount++], (Object)inItem);
        }
        int outputCount = 0;
        ModuleItem[] outputs = new ModuleItem[]{buffer, result};
        for (ModuleItem outItem : info.outputs()) {
            Assert.assertSame((Object)outputs[outputCount++], (Object)outItem);
        }
    }

    private void assertItem(String name, Class<?> type, String label, ItemIO ioType, boolean required, boolean persist, String persistKey, String style, Object value, Object min, Object max, Object softMin, Object softMax, Number stepSize, ModuleItem<?> item) {
        Assert.assertEquals((Object)name, (Object)item.getName());
        Assert.assertSame(type, (Object)item.getType());
        Assert.assertEquals((Object)label, (Object)item.getLabel());
        Assert.assertSame((Object)ioType, (Object)item.getIOType());
        Assert.assertEquals((Object)required, (Object)item.isRequired());
        Assert.assertEquals((Object)persist, (Object)item.isPersisted());
        Assert.assertEquals((Object)persistKey, (Object)item.getPersistKey());
        Assert.assertEquals((Object)style, (Object)item.getWidgetStyle());
        Assert.assertEquals((Object)value, (Object)item.getDefaultValue());
        Assert.assertEquals((Object)min, (Object)item.getMinimumValue());
        Assert.assertEquals((Object)max, (Object)item.getMaximumValue());
        Assert.assertEquals((Object)softMin, (Object)item.getSoftMinimum());
        Assert.assertEquals((Object)softMax, (Object)item.getSoftMaximum());
        Assert.assertEquals((Object)stepSize, (Object)item.getStepSize());
    }

    @Test
    public void testReaderSanity() throws Exception {
        String script = "% @LogService log\n% @OUTPUT Integer output";
        ScriptInfo info = new ScriptInfo(context, "hello.bsizes", (Reader)new StringReader("% @LogService log\n% @OUTPUT Integer output"));
        BufferedReader reader1 = info.getReader();
        BufferedReader reader2 = info.getReader();
        Assert.assertEquals((String)"Readers are not independent.", (long)reader1.read(), (long)reader2.read());
    }

    private static class BindingSizesBindings
    extends HashMap<String, Object>
    implements Bindings {
        private BindingSizesBindings() {
        }
    }

    private static class BindingSizesEngine
    extends AbstractScriptEngine {
        private BindingSizesEngine() {
            this.engineScopeBindings = new BindingSizesBindings();
        }

        public Object eval(String script) throws ScriptException {
            return this.eval(new StringReader(script));
        }

        public Object eval(Reader reader) throws ScriptException {
            Bindings bindings = this.getBindings(100);
            return bindings.size();
        }
    }

    @Plugin(type=ScriptLanguage.class)
    public static class BindingSizes
    extends AbstractScriptLanguage {
        public ScriptEngine getScriptEngine() {
            return new BindingSizesEngine();
        }

        public List<String> getNames() {
            return Arrays.asList("BindingSizes");
        }

        public List<String> getExtensions() {
            return Arrays.asList("bsizes");
        }
    }
}

